
	ifdef SNS_BMPscreen_UseBuffer_4Color
	ifndef SNS_Use4ColorFont
SNS_Use4ColorFont equ 1	;MUST use 4 color font in this mode!
	endif
	endif

;We can only update 1/4 of the screen per NMI ($0800 of $2000)
;Bufferbank is the offset to that 1/4 in ram 

bufferbank equ $80	;Zero page address for bufferbank


z_Regs equ $20		;Used for fake Z80 register pairs

ramarea equ $200	;Define some space for program vars
					; First 16 bytes reserved for core.

	org $8000		;Start of ROM
	sei				;Stop interrupts
  
;ScreenInit

		 ;aaaabbbb -aaa=base addr for BG2 bbb=base addr for BG1
	lda #%00010001
	sta $210B 		;BG1 & BG2 VRAM location register [BG12NBA] 
	
	;     xxxxxxss 	- xxx=address… ss=SC size  00=32x32 01=64x32 10=32x64 11=64x64
	stz $2107		;BG1SC - BG1 Tilemap VRAM location
	
	
	; abcdefff - abcd=tile sizes e=pri fff=mode def
	ifdef SNS_BMPscreen_UseBuffer_4Color
		lda #%00001000		;4 color tilemap
	else
		lda #%00001001		;16 color tilemap
	endif
	sta $2105		;BGMODE - Screen mode register
	
	;	  x000bbbb - x=screen disable (1=disable) bbbb=brightness (15=max)
	lda #%10000000	;Screen off
	sta $2100		;INIDISP - Screen display register

	
;Define the palette

	stz $2121		;CGADD - Colour selection  (0=Back)
		 
					;Color 0=Black
	stz $2122		;CGDATA - Colour data register gggrrrrr 
	stz $2122		;CGDATA - Colour data register ?bbbbbgg

	lda #%00001111	;Color 1=Purple
	sta $2122		;CGDATA - Colour data register gggrrrrr 
	lda #%00111100	;
	sta $2122		;CGDATA - Colour data register ?bbbbbgg
	
	lda #%11100000	;Color 2=Cyan
	sta $2122		;CGDATA - Colour data register gggrrrrr 
	lda #%11111111	;
	sta $2122		;CGDATA - Colour data register ?bbbbbgg
	
					;Color 3=White
	sta $2122		;CGDATA - Colour data register gggrrrrr 
	sta $2122		;CGDATA - Colour data register ?bbbbbgg

	
;Set Scroll position

	stz $210D  		;BG1HOFS BG1 horizontal scroll   
	stz $210D  		;BG1HOFS
	
	lda #-1
	sta $210E  		;BG1VOFS BG1 vertical scroll 
	stz $210E  		;BG1VOFS
	
;Set up the VRAM update

	;	   i000abcd - I 0=inc on $2118 or $2139 1=$2119 or $213A… abcd=move size
	 lda #%10000000
	 sta $2115 		;VMAIN - Video port control (Inc on write to $2119)

;Draw the bitmap Tilemap

	;ldx #0				;$300=768 tiles (X already 0)
	iny ;ldy #1			;TileStart 256+ (Y already 0)
				
	lda #$40
	sta $2116		;MemL -Video port address [VMADDL/VMADDH] 
	stz $2117		;MemH
	
; z_b = SX... z_c = SY... X=Width... Y= Height... HL=start tile
FillBitmapScreen:
	stx $2118		
	sty $2119
	inx	;Increase Tile Number
	bne FillBitmapScreen
	iny						
	cpy #4
	bne FillBitmapScreen
	
;Init the Buffer pointer

	ifdef SNS_BMPscreen_UseBuffer
		stz Bufferbank		;Set Buffer Start =0
	
		lda #%10000000		;Turn on interrupts
		sta $4200
	endif
	
;Turn on the screen	

		; ---S4321 - S=sprites 4-1=enable Bgx
	lda #%00000001	;Turn on BG1
	sta $212C 		;Main screen designation [TM]    
	
	;	  x000bbbb - x=screen disable (1=disable) bbbb=brightness (15=max)
	lda #%00001111	;Screen on
	sta $2100		;INIDISP - Screen display register
	
	jsr ClearRam	;Run Adventure engine ram clear and CLS
	