
z_Regs equ $20		;Used for fake Z80 register pairs

ramarea equ $200	;Define some space for program vars
					; First 16 bytes reserved for core.

	org $8000		;Start of ROM
	sei				;Stop interrupts
  
;ScreenInit

		 ;aaaabbbb -aaa=base addr for BG2 bbb=base addr for BG1
	lda #%00010001
	sta $210B 		;BG1 & BG2 VRAM location register [BG12NBA] 
	
	;     xxxxxxss 	- xxx=address… ss=SC size  00=32x32 01=64x32 10=32x64 11=64x64
	stz $2107		;BG1SC - BG1 Tilemap VRAM location
	
	; abcdefff - abcd=tile sizes e=pri fff=mode def
	lda #%00001001
	sta $2105		;BGMODE - Screen mode register
	
	;	  x000bbbb - x=screen disable (1=disable) bbbb=brightness (15=max)
	lda #%10000000	;Screen off
	sta $2100		;INIDISP - Screen display register

	
;Define the palette

	stz $2121		;CGADD - Colour selection  (0=Back)
		 
					;Color 0=Black
	stz $2122		;CGDATA - Colour data register gggrrrrr 
	stz $2122		;CGDATA - Colour data register ?bbbbbgg

	lda #%00001111	;Color 1=Purple
	sta $2122		;CGDATA - Colour data register gggrrrrr 
	lda #%00111100	;
	sta $2122		;CGDATA - Colour data register ?bbbbbgg
	
	lda #%11100000	;Color 2=Cyan
	sta $2122		;CGDATA - Colour data register gggrrrrr 
	lda #%11111111	;
	sta $2122		;CGDATA - Colour data register ?bbbbbgg
	
					;Color 3=White
	sta $2122		;CGDATA - Colour data register gggrrrrr 
	sta $2122		;CGDATA - Colour data register ?bbbbbgg

;Load the font tile patterns

	;	  i000abcd - I 0=inc on $2118 or $2139 1=$2119 or $213A… abcd=move size
	lda #%10000000
	sta $2115 		;VMAIN - Video port control (Inc on write to $2119)

	stz $2116		;VRAM MemL
	lda #$10
	sta $2117		;VRAM MemH $1000
	
	lda #BitmapFont&255
	sta $20
	lda #BitmapFont/256
	sta $21
	
	ifdef SNS_Use4ColorFont
		ldx #4				;4*256= 64*16 chars (Second set empty)
	else 
		ldx #4*2			;64 chars, 2 sets of bitplanes
	endif
	ldy #0
fontchar_loopX:
	phx

fontchar_loopY:			
		ldx #8				;We need to transfer 8 lines 
fontchar_loopL:
		lda ($20),y
		sta $2118			;Write Word data to data-port
		iny
		lda ($20),y
		sta $2119			
		iny
		dex 
		bne fontchar_loopL
		
		ifdef SNS_Use4ColorFont
			ldx #8				;8 Empty Words
fontchar_loopL2:
			stz $2118			;Write Word data to data-port
			stz $2119			
			dex
			bne fontchar_loopL2
		endif
	
		tya
		bne fontchar_loopY
		inc $21					;Inc to byte of address
	plx 
	dex
	bne fontchar_loopX
	
	
;Set Scroll position

	stz $210D  		;BG1HOFS BG1 horizontal scroll   
	stz $210D  		;BG1HOFS
	
	lda #-1
	sta $210E  		;BG1VOFS BG1 vertical scroll 
	stz $210E  		;BG1VOFS

	
;Clear Screen

	; stz $2116		;MemL -Video port address [VMADDL/VMADDH] 
	; stz $2117		;MemH

	; ldy #4			;Tilemap Size: 32*32 = 1024
	; ldx #0
; ClearTilemap:
	; stz $2118		;Zero all Tiles in Tilemap
	; stz $2119
	; dex
	; bne ClearTilemap
	; dey
	; bne ClearTilemap
	
	
;Turn on the screen	

		; ---S4321 - S=sprites 4-1=enable Bgx
	lda #%00000001	;Turn on BG1
	sta $212C 		;Main screen designation [TM]    
	
	;	  x000bbbb - x=screen disable (1=disable) bbbb=brightness (15=max)
	lda #%00001111	;Screen on
	sta $2100		;INIDISP - Screen display register
	
	
	jsr ClearRam	;Run Adventure engine ram clear and CLS
	