
		
NewLine:
	lda #0		
	sta z_d			;Cursor X=0

	inc z_e			;Cursor Y++

	lda z_e
	cmp #23			;At bottom of screen?
	bcs cls			;no? return, else cls!
	rts
	
Cls:
	lda z_h
	pha
	lda z_l
	pha
		lda z_b
		pha
		lda z_c
		pha
			stz z_d			;x,y
			stz z_e
			stz z_l			;char,inc
			lda #$20
			sta z_h

			lda #32			;width,height
			sta z_b
			lda #24
			sta z_c

			jsr fillarea	;Clear the screen
		pla
		sta	z_c
		pla
		sta z_b
	pla
	sta	z_l
	pla
	sta z_h
	rts

Slowdown:	;this exists for systems that run too fast
	nop
	nop
	nop
	nop
	nop
	nop
	rts

	
	
	
	
printnumber:		;print char a at loc de
	clc
	adc #48			;ascii 0
	
printchar:			;print char a with sprite routine	
	cmp #0
	bne notprintchar0	;0=Skip this char
	inc z_d
	rts
notprintchar0:
	tax
	lda z_d
	pha
	lda z_e
	pha
	lda z_h
	pha
	lda z_l
	pha
		txa
		sec
		sbc #32		;no char below 32
		cmp #64		;Lowercase?
		bcc notlowercase
		sec			
		sbc #32		;Convert to upper!
notlowercase:
		pha
			stz z_h		;4  color mode: Address=$2000 (Ypos *32*16) + X*16
			stz z_l		;16 color mode: Address=$2000 (Ypos *32*32) + X*32
			lda z_d		;			    2 bytes per VRAM address
			lsr 
			ror z_l		;*128
			lsr 
			ror z_l		;*64
			lsr 
			ror z_l		;*32
			ifndef SNS_BMPscreen_UseBuffer
				lsr 
				ror z_l		;*16
			endif
			ifdef SNS_BMPscreen_UseBuffer_4Color
				lsr 
				ror z_l		;*16/*8
			endif 
			sta z_h
			
			lda z_e			;Ypos
			ifndef SNS_BMPscreen_UseBuffer_4Color
				asl			
			endif
			ifdef SNS_BMPscreen_UseBuffer
				asl
			endif
			clc
			adc z_h
			adc #$20		;Tile 256+
			sta z_h
		pla
		
;Calculate Bitmap Source
		sta z_d
		lda #0
		lsr z_d			;*128
		ror
		lsr z_d			;*64
		ror
		lsr z_d			;*32
		ror
		ifdef SNS_Use4ColorFont
			lsr z_d			;*16
			ror
		endif
		adc #<Bitmapfont
		sta z_e
		lda z_d
		adc #>Bitmapfont
		sta z_d		

		ifndef SNS_BMPscreen_UseBuffer	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;			
										; VRAM DIRECT
PrintChar_WaitVblank:
			lda $4212 			;HVBJOY - Status 	
				; xy00000a		- x=vblank state y=hblank state a=joypad ready
			and #%10000000
			beq PrintChar_WaitVblank	;Wait until we get nonzero - this means we're in VBLANK
			
			lda z_l
			sta $2116		;VRAM MemL
			lda z_h
			sta $2117		;VRAM MemH
			
			ldy #0
printchar_SendBitmap:		
		
			
			lda (z_de),y
			sta $2118			;Write Word data to data-port
			iny
			lda (z_de),y
			sta $2119			
			iny
			ifdef SNS_Use4ColorFont
				cpy #16				;16 bytes per char in 4 color mode
			else
				cpy #32				;32 bytes per char in 16 color mode
			endif
			bne printchar_SendBitmap
			
			ifndef SNS_BMPscreen_UseBuffer_4Color
			ifdef SNS_Use4ColorFont
printchar_SendBitmapZero:		
				stz $2118			;Bitplanes 2/3 unused in 4 color mode
				dey
				stz $2119			
				dey
				bne printchar_SendBitmapZero				
			endif
			endif 
			lda $4212 			;HVBJOY - Status 	
				; xy00000a		- x=vblank state y=hblank state a=joypad ready
			and #%10000000
			beq PrintChar_WaitVblank	;Wait until we get nonzero - this means we're in VBLANK
			
		else	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
						;BUFFERED
			lda z_l
			sta $2181	;WMADDL
			lda z_h
			sta $2182	;WMADDM
			stz $2183	;WMADDH
			
			ldy #0
printchar_SendBitmap:		
			lda (z_de),y
			sta $2180		;Wram DATA - Bitplane 0/2
			iny
			lda (z_de),y
			sta $2180		;Wram DATA - Bitplane 1/3
			iny
			ifdef SNS_Use4ColorFont
				cpy #16				;16 bytes per char in 4 color mode
			else
				cpy #32				;32 bytes per char in 16 color mode
			endif
			bne printchar_SendBitmap
			
			ifndef SNS_BMPscreen_UseBuffer_4Color
			ifdef SNS_Use4ColorFont
printchar_SendBitmapZero:		
				stz $2180			;Bitplanes 2/3 unused in 4 color mode
				dey
				stz $2180
				dey
				bne printchar_SendBitmapZero				
			endif		
			endif
		endif	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	pla
	sta z_l
	pla 
	sta z_h
	pla
	sta z_e
	pla 
	sta z_d
	
	txa
printchar0:
	inc z_d				;Xpos ++
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


readjoystick:	;Returnds %---FRLDU
	ldx #$01				;Send a 1 to joysticks (strobe reset)
	stx $4016				;JOYPAD1 port
	 					;Send a 0 to joysticks (read data)
	stz $4016				;JOYPAD1 port

	ldx #8					;Read in 8 bits from each joystick
Player_ReadControlsDualloop:
	lda $4016				;JOYPAD1
	lsr 	   				; bit0 -> Carry
	ror z_as  				;Add carry to Joy1 data

	dex 
	bne Player_ReadControlsDualloop
	
	lda z_as
	eor #255				;Flip bits so unpressed=1

SwapNibbles:		;$AB -> $BA
	asl 		;(shift left - bottom bit zero)
	adc #$80 	;(pop top bit off - add carry)
	rol 		;(shift carry in)
	;2 bits moved
	asl 		;(shift left - bottom bit zero)
	adc #$80 	;(pop top bit off - add carry)
	rol 		;(shift carry in)
	rts	;4 bits moved
	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		
BitmapFont:	
	ifdef SNS_Use4ColorFont
		ds 16	;Space
		db $10,$10,$08,$18,$00,$18,$00,$18,$00,$18,$00,$00,$10,$08,$00,$00     ;  0
		db $28,$28,$28,$6C,$00,$28,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;  2
		db $00,$00,$28,$28,$00,$7C,$00,$28,$54,$28,$28,$00,$00,$00,$00,$00     ;  4
		db $18,$18,$2A,$3E,$00,$48,$00,$3C,$00,$12,$54,$28,$18,$00,$00,$00     ;  6
		db $02,$02,$80,$C4,$00,$C8,$00,$10,$00,$20,$44,$02,$86,$00,$00,$00     ;  8
		db $10,$10,$28,$28,$00,$28,$00,$72,$00,$94,$04,$88,$72,$00,$00,$00     ; 10
		db $0C,$0C,$08,$1C,$00,$30,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 12
		db $18,$18,$08,$18,$00,$30,$00,$30,$00,$30,$10,$08,$18,$00,$00,$00     ; 14
		db $18,$18,$08,$18,$00,$0C,$00,$0C,$00,$0C,$10,$08,$18,$00,$00,$00     ; 16
		db $08,$08,$41,$49,$00,$2A,$00,$1C,$00,$14,$00,$22,$41,$00,$00,$00     ; 18
		db $00,$00,$08,$18,$00,$18,$00,$7E,$00,$18,$10,$08,$00,$00,$00,$00     ; 20
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$10,$08,$18,$00,$30,$00     ; 22
		db $00,$00,$00,$00,$00,$00,$00,$7E,$7E,$00,$00,$00,$00,$00,$00,$00     ; 24
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$10,$08,$18,$00,$00,$00     ; 26
		db $02,$02,$00,$04,$00,$08,$00,$10,$00,$20,$40,$00,$80,$00,$00,$00     ; 28
		db $7C,$7C,$82,$C6,$00,$D6,$00,$D6,$92,$44,$C6,$00,$7C,$00,$00,$00     ; 30
		db $10,$10,$08,$18,$00,$18,$00,$18,$00,$18,$10,$08,$08,$00,$00,$00     ; 32
		db $3C,$3C,$2A,$7E,$00,$06,$00,$3C,$00,$60,$54,$2A,$3C,$00,$00,$00     ; 34
		db $3C,$3C,$2A,$7E,$00,$06,$00,$1C,$00,$06,$54,$2A,$3C,$00,$00,$00     ; 36
		db $18,$18,$28,$3C,$00,$64,$00,$CC,$00,$7C,$04,$08,$08,$00,$00,$00     ; 38
		db $3C,$3C,$2A,$7E,$00,$60,$00,$7C,$00,$06,$54,$2A,$3E,$00,$00,$00     ; 40
		db $3C,$3C,$2A,$7E,$00,$60,$00,$7C,$00,$66,$44,$22,$3C,$00,$00,$00     ; 42
		db $3C,$3C,$2A,$7E,$00,$06,$00,$0C,$00,$18,$10,$08,$10,$00,$00,$00     ; 44
		db $3C,$3C,$22,$66,$00,$66,$00,$3C,$00,$66,$44,$22,$3C,$00,$00,$00     ; 46
		db $3C,$3C,$22,$66,$00,$66,$00,$3E,$00,$06,$54,$2A,$3C,$00,$00,$00     ; 48
		db $00,$00,$00,$00,$18,$18,$00,$18,$00,$00,$10,$08,$18,$00,$00,$00     ; 50
		db $00,$00,$00,$00,$18,$18,$00,$18,$00,$00,$10,$08,$18,$00,$30,$00     ; 52
		db $0C,$0C,$08,$1C,$00,$38,$00,$60,$00,$38,$14,$08,$0C,$00,$00,$00     ; 54
		db $00,$00,$00,$00,$2A,$7E,$00,$00,$00,$00,$54,$2A,$00,$00,$00,$00     ; 56
		db $60,$60,$20,$70,$00,$38,$00,$0C,$00,$38,$50,$20,$60,$00,$00,$00     ; 58
		db $3C,$3C,$22,$76,$00,$06,$00,$1C,$00,$00,$08,$10,$18,$00,$00,$00     ; 60
		db $7C,$7C,$82,$CE,$00,$A6,$00,$B6,$02,$C4,$50,$A0,$7C,$00,$00,$00     ; 62
		db $18,$18,$28,$3C,$00,$66,$00,$66,$00,$7E,$44,$22,$24,$00,$00,$00     ; 64
		db $3C,$3C,$22,$66,$00,$66,$00,$7C,$00,$66,$44,$22,$3C,$00,$00,$00     ; 66
		db $38,$38,$28,$7C,$00,$C0,$00,$C0,$00,$C0,$54,$28,$38,$00,$00,$00     ; 68
		db $3C,$3C,$20,$64,$00,$66,$00,$66,$00,$66,$44,$20,$38,$00,$00,$00     ; 70
		db $3C,$3C,$2A,$7E,$00,$60,$00,$78,$00,$60,$54,$2A,$3C,$00,$00,$00     ; 72
		db $38,$38,$28,$7C,$00,$60,$00,$78,$00,$60,$40,$20,$20,$00,$00,$00     ; 74
		db $3C,$3C,$22,$66,$00,$C0,$00,$C0,$00,$CC,$44,$22,$3C,$00,$00,$00     ; 76
		db $24,$24,$22,$66,$00,$66,$00,$7E,$00,$66,$44,$22,$24,$00,$00,$00     ; 78
		db $10,$10,$08,$18,$00,$18,$00,$18,$00,$18,$10,$08,$08,$00,$00,$00     ; 80
		db $08,$08,$08,$0C,$00,$0C,$00,$0C,$00,$4C,$54,$A8,$78,$00,$00,$00     ; 82
		db $24,$24,$22,$66,$00,$6C,$00,$78,$00,$6C,$44,$22,$24,$00,$00,$00     ; 84
		db $20,$20,$20,$60,$00,$60,$00,$60,$00,$60,$54,$2A,$3E,$00,$00,$00     ; 86
		db $44,$44,$AA,$EE,$00,$FE,$00,$D6,$00,$D6,$44,$92,$44,$00,$00,$00     ; 88
		db $44,$44,$A2,$E6,$00,$F6,$00,$DE,$00,$CE,$44,$82,$44,$00,$00,$00     ; 90
		db $38,$38,$28,$6C,$00,$C6,$00,$C6,$00,$C6,$44,$28,$38,$00,$00,$00     ; 92
		db $38,$38,$20,$6C,$00,$64,$00,$7C,$00,$60,$40,$20,$20,$00,$00,$00     ; 94
		db $38,$38,$28,$6C,$00,$C6,$00,$C6,$00,$CA,$74,$00,$3A,$00,$00,$00     ; 96
		db $3C,$3C,$22,$66,$00,$66,$00,$7C,$00,$6C,$44,$22,$26,$00,$00,$00     ; 98
		db $3C,$3C,$22,$7E,$00,$60,$00,$3C,$00,$06,$54,$2A,$3C,$00,$00,$00     ;100
		db $3C,$3C,$2A,$7E,$00,$18,$00,$18,$00,$18,$10,$08,$08,$00,$00,$00     ;102
		db $24,$24,$22,$66,$00,$66,$00,$66,$00,$66,$44,$22,$3C,$00,$00,$00     ;104
		db $24,$24,$22,$66,$00,$66,$00,$66,$00,$66,$14,$28,$18,$00,$00,$00     ;106
		db $44,$44,$82,$C6,$00,$D6,$00,$D6,$00,$FE,$AA,$44,$44,$00,$00,$00     ;108
		db $C6,$C6,$28,$6C,$00,$38,$00,$38,$00,$6C,$44,$82,$44,$00,$00,$00     ;110
		db $24,$24,$22,$66,$00,$66,$00,$3C,$00,$18,$10,$08,$08,$00,$00,$00     ;112
		db $7C,$7C,$A8,$FC,$00,$0C,$00,$18,$00,$30,$54,$2A,$7C,$00,$00,$00     ;114
		db $1C,$1C,$20,$30,$00,$30,$00,$30,$00,$30,$10,$20,$1C,$00,$00,$00     ;116
		db $80,$80,$00,$40,$00,$20,$00,$10,$00,$08,$04,$00,$02,$00,$00,$00     ;118
		db $38,$38,$08,$0C,$00,$0C,$00,$0C,$00,$0C,$04,$08,$38,$00,$00,$00     ;120
		db $18,$18,$28,$3C,$00,$7E,$00,$18,$00,$18,$10,$08,$18,$00,$00,$00     ;122
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$FF,$00,$FF,$00     ;124
		db $30,$30,$08,$18,$00,$0C,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;126
		db $00,$00,$00,$00,$00,$38,$00,$0C,$00,$7C,$44,$88,$78,$00,$00,$00     ;128

	else
		ds 32
		db $10,$10,$08,$18,$00,$18,$00,$18,$00,$18,$00,$00,$10,$08,$00,$00     ;  0
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;  1
		db $28,$28,$28,$6C,$00,$28,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;  2
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;  3
		db $00,$00,$28,$28,$00,$7C,$00,$28,$54,$28,$28,$00,$00,$00,$00,$00     ;  4
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;  5
		db $18,$18,$2A,$3E,$00,$48,$00,$3C,$00,$12,$54,$28,$18,$00,$00,$00     ;  6
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;  7
		db $02,$02,$80,$C4,$00,$C8,$00,$10,$00,$20,$44,$02,$86,$00,$00,$00     ;  8
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;  9
		db $10,$10,$28,$28,$00,$28,$00,$72,$00,$94,$04,$88,$72,$00,$00,$00     ; 10
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 11
		db $0C,$0C,$08,$1C,$00,$30,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 12
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 13
		db $18,$18,$08,$18,$00,$30,$00,$30,$00,$30,$10,$08,$18,$00,$00,$00     ; 14
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 15
		db $18,$18,$08,$18,$00,$0C,$00,$0C,$00,$0C,$10,$08,$18,$00,$00,$00     ; 16
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 17
		db $08,$08,$41,$49,$00,$2A,$00,$1C,$00,$14,$00,$22,$41,$00,$00,$00     ; 18
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 19
		db $00,$00,$08,$18,$00,$18,$00,$7E,$00,$18,$10,$08,$00,$00,$00,$00     ; 20
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 21
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$10,$08,$18,$00,$30,$00     ; 22
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 23
		db $00,$00,$00,$00,$00,$00,$00,$7E,$7E,$00,$00,$00,$00,$00,$00,$00     ; 24
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 25
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$10,$08,$18,$00,$00,$00     ; 26
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 27
		db $02,$02,$00,$04,$00,$08,$00,$10,$00,$20,$40,$00,$80,$00,$00,$00     ; 28
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 29
		db $7C,$7C,$82,$C6,$00,$D6,$00,$D6,$92,$44,$C6,$00,$7C,$00,$00,$00     ; 30
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 31
		db $10,$10,$08,$18,$00,$18,$00,$18,$00,$18,$10,$08,$08,$00,$00,$00     ; 32
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 33
		db $3C,$3C,$2A,$7E,$00,$06,$00,$3C,$00,$60,$54,$2A,$3C,$00,$00,$00     ; 34
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 35
		db $3C,$3C,$2A,$7E,$00,$06,$00,$1C,$00,$06,$54,$2A,$3C,$00,$00,$00     ; 36
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 37
		db $18,$18,$28,$3C,$00,$64,$00,$CC,$00,$7C,$04,$08,$08,$00,$00,$00     ; 38
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 39
		db $3C,$3C,$2A,$7E,$00,$60,$00,$7C,$00,$06,$54,$2A,$3E,$00,$00,$00     ; 40
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 41
		db $3C,$3C,$2A,$7E,$00,$60,$00,$7C,$00,$66,$44,$22,$3C,$00,$00,$00     ; 42
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 43
		db $3C,$3C,$2A,$7E,$00,$06,$00,$0C,$00,$18,$10,$08,$10,$00,$00,$00     ; 44
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 45
		db $3C,$3C,$22,$66,$00,$66,$00,$3C,$00,$66,$44,$22,$3C,$00,$00,$00     ; 46
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 47
		db $3C,$3C,$22,$66,$00,$66,$00,$3E,$00,$06,$54,$2A,$3C,$00,$00,$00     ; 48
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 49
		db $00,$00,$00,$00,$18,$18,$00,$18,$00,$00,$10,$08,$18,$00,$00,$00     ; 50
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 51
		db $00,$00,$00,$00,$18,$18,$00,$18,$00,$00,$10,$08,$18,$00,$30,$00     ; 52
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 53
		db $0C,$0C,$08,$1C,$00,$38,$00,$60,$00,$38,$14,$08,$0C,$00,$00,$00     ; 54
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 55
		db $00,$00,$00,$00,$2A,$7E,$00,$00,$00,$00,$54,$2A,$00,$00,$00,$00     ; 56
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 57
		db $60,$60,$20,$70,$00,$38,$00,$0C,$00,$38,$50,$20,$60,$00,$00,$00     ; 58
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 59
		db $3C,$3C,$22,$76,$00,$06,$00,$1C,$00,$00,$08,$10,$18,$00,$00,$00     ; 60
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 61
		db $7C,$7C,$82,$CE,$00,$A6,$00,$B6,$02,$C4,$50,$A0,$7C,$00,$00,$00     ; 62
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 63
		db $18,$18,$28,$3C,$00,$66,$00,$66,$00,$7E,$44,$22,$24,$00,$00,$00     ; 64
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 65
		db $3C,$3C,$22,$66,$00,$66,$00,$7C,$00,$66,$44,$22,$3C,$00,$00,$00     ; 66
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 67
		db $38,$38,$28,$7C,$00,$C0,$00,$C0,$00,$C0,$54,$28,$38,$00,$00,$00     ; 68
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 69
		db $3C,$3C,$20,$64,$00,$66,$00,$66,$00,$66,$44,$20,$38,$00,$00,$00     ; 70
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 71
		db $3C,$3C,$2A,$7E,$00,$60,$00,$78,$00,$60,$54,$2A,$3C,$00,$00,$00     ; 72
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 73
		db $38,$38,$28,$7C,$00,$60,$00,$78,$00,$60,$40,$20,$20,$00,$00,$00     ; 74
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 75
		db $3C,$3C,$22,$66,$00,$C0,$00,$C0,$00,$CC,$44,$22,$3C,$00,$00,$00     ; 76
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 77
		db $24,$24,$22,$66,$00,$66,$00,$7E,$00,$66,$44,$22,$24,$00,$00,$00     ; 78
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 79
		db $10,$10,$08,$18,$00,$18,$00,$18,$00,$18,$10,$08,$08,$00,$00,$00     ; 80
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 81
		db $08,$08,$08,$0C,$00,$0C,$00,$0C,$00,$4C,$54,$A8,$78,$00,$00,$00     ; 82
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 83
		db $24,$24,$22,$66,$00,$6C,$00,$78,$00,$6C,$44,$22,$24,$00,$00,$00     ; 84
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 85
		db $20,$20,$20,$60,$00,$60,$00,$60,$00,$60,$54,$2A,$3E,$00,$00,$00     ; 86
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 87
		db $44,$44,$AA,$EE,$00,$FE,$00,$D6,$00,$D6,$44,$92,$44,$00,$00,$00     ; 88
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 89
		db $44,$44,$A2,$E6,$00,$F6,$00,$DE,$00,$CE,$44,$82,$44,$00,$00,$00     ; 90
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 91
		db $38,$38,$28,$6C,$00,$C6,$00,$C6,$00,$C6,$44,$28,$38,$00,$00,$00     ; 92
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 93
		db $38,$38,$20,$6C,$00,$64,$00,$7C,$00,$60,$40,$20,$20,$00,$00,$00     ; 94
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 95
		db $38,$38,$28,$6C,$00,$C6,$00,$C6,$00,$CA,$74,$00,$3A,$00,$00,$00     ; 96
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 97
		db $3C,$3C,$22,$66,$00,$66,$00,$7C,$00,$6C,$44,$22,$26,$00,$00,$00     ; 98
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 99
		db $3C,$3C,$22,$7E,$00,$60,$00,$3C,$00,$06,$54,$2A,$3C,$00,$00,$00     ;100
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;101
		db $3C,$3C,$2A,$7E,$00,$18,$00,$18,$00,$18,$10,$08,$08,$00,$00,$00     ;102
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;103
		db $24,$24,$22,$66,$00,$66,$00,$66,$00,$66,$44,$22,$3C,$00,$00,$00     ;104
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;105
		db $24,$24,$22,$66,$00,$66,$00,$66,$00,$66,$14,$28,$18,$00,$00,$00     ;106
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;107
		db $44,$44,$82,$C6,$00,$D6,$00,$D6,$00,$FE,$AA,$44,$44,$00,$00,$00     ;108
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;109
		db $C6,$C6,$28,$6C,$00,$38,$00,$38,$00,$6C,$44,$82,$44,$00,$00,$00     ;110
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;111
		db $24,$24,$22,$66,$00,$66,$00,$3C,$00,$18,$10,$08,$08,$00,$00,$00     ;112
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;113
		db $7C,$7C,$A8,$FC,$00,$0C,$00,$18,$00,$30,$54,$2A,$7C,$00,$00,$00     ;114
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;115
		db $1C,$1C,$20,$30,$00,$30,$00,$30,$00,$30,$10,$20,$1C,$00,$00,$00     ;116
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;117
		db $80,$80,$00,$40,$00,$20,$00,$10,$00,$08,$04,$00,$02,$00,$00,$00     ;118
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;119
		db $38,$38,$08,$0C,$00,$0C,$00,$0C,$00,$0C,$04,$08,$38,$00,$00,$00     ;120
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;121
		db $18,$18,$28,$3C,$00,$7E,$00,$18,$00,$18,$10,$08,$18,$00,$00,$00     ;122
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;123
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$FF,$00,$FF,$00     ;124
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;125
		db $30,$30,$08,$18,$00,$0C,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;126
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;127
		db $00,$00,$00,$00,$00,$38,$00,$0C,$00,$7C,$44,$88,$78,$00,$00,$00     ;128
	endif

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	ifdef SNS_BMPscreen_UseBuffer
	ifndef CustomNmihandler
CustomNmihandler:			;Copy 1/4 of Patterns Via DMA each NMI
	pha
;Set DMA Settings
		;lda #128			;Inc address on write to $2119
		;sta $2115			
		
		lda #%00000001		;Write mode 001=two bytes alternate
		sta $4300	
		lda #$18			;Destination $21xx= 2118
		sta $4301		
;Set DMA Dest (VRAM $2000)
		stz $2116			;MemL -Video port address [VMADDL/VMADDH]
		lda Bufferbank
		clc
		ifdef SNS_BMPscreen_UseBuffer_4Color
			adc #$18	
		else
			adc #$20	
		endif
		sta $2117			;MemH
;Set DMA Source ($7E2000+)
		stz $4302			;Low Byte
		lda Bufferbank
		rol					;2 bytes per Vram Address
		clc
		adc #$20
		sta $4303			;Mid Byte
		lda #$7E			
		sta $4304			;Upper Byte
;Bytecount
		lda #<($1000)
		sta $4305			;No of bytes (24 bit - Little endian
		lda #>($1000)			;(only 1st 16 bits used?)
		sta $4306
		lda #0
		sta $4307
;Do the transfer
		lda #0
		sta $420C			;Disable H-DMA transfer 
		lda #%00000001		
		sta $420B			;enable DMA 0 (bit0=1)
;Update pointer for next NMI
		lda Bufferbank
		clc 
		adc #$08			;Move to next strip
		ifdef SNS_BMPscreen_UseBuffer_4Color
			cmp #$18		;4 color
		else
			cmp #$30		;16 color
		endif 
		bcc BBOk
		lda #0
BBOk:		
		sta Bufferbank		;Store Next Transfer pos

		;lda #0
		;sta $2115			;Inc address on write to $2118
	pla
	rti
	endif
	endif
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;	Footer
	
	org $FFC0
     ; "123456789012345678901"
	db "www.ChibiAkumas.com  "	; Program title (21 byte Ascii string)

	db $20		;Rom mode/speed (bits 7-4 = speed, bits 3-0 = map mode)
	db $00		;Rom type (bits 7-4 = co-processor, bits 3-0 = type)
	db $01 		;Rom size in banks (1bank=32k)
	db $00 		;Ram size (0=none)
	db $00		;Country/video refresh (ntsc 60hz, pal 50hz) (0=j 1=us/eu)
	db $00		;Developer id code
	db $00		;Rom version number
	db "cc"		;Complement check
	db "cs" 	;Checksum

;65816 mode vectors
	dw $0000 	;Reserved
	dw $0000 	;Reserved
	dw $0000 	;Cop vector   (cop opcode)
	dw $0000 	;Brk vector   (brk opcode)
	dw $0000 	;Abort vector (unused)
	ifdef CustomNmihandler
		dw CustomNmihandler	;Vblank interrupt handler
	else
		dw $0000	;Vblank interrupt handler
	endif
	dw $0000 	;Reset vector (unused)
	dw $0000 	;Irq vector   (h/v-timer/external interrupt)

;6502 mode vectors
	dw $0000 	;Reserved
	dw $0000	;Reserved
	dw $0000 	;Cop vector   (cop opcode)
	dw $0000 	;Brk vector   (unused)
	dw $0000 	;Abort vector (unused)
	ifdef CustomNmihandler
		dw CustomNmihandler	;Vblank interrupt handler		
	else
		dw $0000	;Vblank interrupt handler
	endif
	dw $8000 	;Reset vector (cpu is always in 6502 mode on reset)
	dw $0000 	;Irq/brk vector
	
	
	