
NewLine:
	lda #0			;Cursor X=0
	sta z_d

	inc z_e			;Cursor Y++

	lda z_e
	cmp #23			;At bottom of screen?
	bcs cls			;no? return, else cls!
	rts

Cls:
	lda z_h
	pha
	lda z_l
	pha
		lda z_b
		pha
		lda z_c
		pha
			lda #0
			sta z_d			;x,y
			sta z_e
			sta z_l			;char,inc
			lda #$20
			sta z_h

			lda #40		;Width,Height
			sta z_b
			lda #$19
			sta z_c

			jsr fillarea	;Clear the screen
		pla
		sta	z_c
		pla
		sta z_b
	pla
	sta	z_l
	pla
	sta z_h
slowdown:	;This exists for systems that run too fast
	rts

	
PrintNumber:		
	clc
	adc #48			;ascii 0

PrintChar:			;print char a at loc de
	cmp #0
	bne Notprintchar0
		inc z_d		;Char=0? then just inc CursorX
		rts
Notprintchar0:	
	tax
	pha
	lda z_h
	pha
	lda z_l
	pha
		lda #$80			;Screen base is $8000
		sta z_h				;VRAM = $8000+ (Ypos*40) + Xpos
		
		lda z_d				;Xpos
		ifdef ScreenWidth32
			clc
			adc #4
		endif
		sta z_l

		ldy z_e				;Ypos
		beq GetVDPScreenPos_YZero
		
		lda z_l
GetVDPScreenPos_Addagain:	;Repeatedly add screen width (40) Y times 
		clc
		adc #40				;40 bytes per line

		bcc GetVDPScreenPos_AddagainB
		inc z_h				;Add Carry
GetVDPScreenPos_AddagainB		
		dey
		bne GetVDPScreenPos_Addagain
		sta z_l
		
GetVDPScreenPos_YZero:	
		txa
		clc
		cmp #64	
		bcc PrintChar_Symbols

		sbc #64
		and #%00011111		;Force uppercase letter
PrintChar_Symbols:
		ldx #0
		sta (z_hl,x)		;Draw the character to the screen
	pla
	sta	z_l
	pla
	sta z_h
	pla
	inc z_d
	rts

	
ReadJoystick:	;Returns %--21RLDU

	lda #6				;Line 6
	ldx #%00100000		;Fire 2 (Enter)
	jsr TestCursorBit
	
	lda #9				;Line 9
	ldx #%00000100		;Fire 1 (Space)
	jsr TestCursorBit
	
	lda #4				;Line 4
	ldx #%10000000		;Right (Numpad 6)
	jsr TestCursorBit
	
	;lda #4				;Line 4
	ldx #%01000000		;Left (Numpad 4)
	jsr TestCursorBit
	
	lda #7				;Line 7
	;ldx #%01000000		;Down (Numpad 2)
	jsr TestCursorBit
	
	lda #3				;Line 3
	;ldx #%01000000		;Up	(Numpad 8)
	jsr TestCursorBit
	lda z_As
	ora #%11000000
	rts
	
TestCursorBit:				;A=Line X=Mask (Return in carry)
	pha
		sta $E810			;Select line
		txa
		and $E812			;test key
		clc					;Clear carry (Pressed)
		beq TestCursorBitB		
		sec					;Set carry (not pressed)
TestCursorBitB:	
		rol z_As			;shift the key into the buildup
	pla
	rts
	