;PCE_Use4ColorFont equ 1

ramarea equ $2200	;Define some space for program vars
					;First 16 bytes reserved for core.

z_Regs equ $40		;Used for fake Z80 register pairs

	org $4000		;Bank $0
	
	setdp $2000		;Define the direct page as #$2000

;This actually runs from $E000 but we remap our banks so we end up at $4000 
;to give us more space for our game code

ProgramStart:
	sei				;Disable interrupts
	csh				;Highspeed Mode
	cld				;Clear Decimal mode	
	
	    ;      T12 - TIQ, IRQ1, IRQ2
	lda #%00000111
	sta $1402		;IRQ mask... 1=Off
	
	lda #$f8		;map in RAM
	tam #%00000010	;TAM1 (2000-3FFF)

	lda #$ff		;map in I/O (#$ff)
	tam #%00000001	;TAM0 (0000-1FFF)
	tax				
	txs				;Init stack pointer
		
	;Page in the banks of our cartridge
	lda #$00		;map in ROM
	tam #%00000100	;TAM1 (4000-5FFF)
	lda #$01		;map in ROM
	tam #%00001000	;TAM1 (6000-7FFF)
	lda #$02		;map in ROM
	tam #%00010000	;TAM1 (8000-9FFF)
	lda #$03		;map in ROM
	tam #%00100000	;TAM1 (A000-BFFF)
	lda #$04		;map in ROM
	tam #%01000000	;TAM1 (C000-DFFF)
	
	jmp Restart4000		;Jump to $4000 area

Restart4000:		
	;Page in last bank (We were running here before)
	lda #$05		;map in ROM
	tam #%10000000	;TAM1 (E000-FFFF)	
	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	cly				;Y=0
ScreenInitAgain:
	lda ScreenInit,y
	sta $0100		;ST0
	iny
	lda ScreenInit,y
	sta $0102		;ST1
	iny
	lda ScreenInit,y
	sta $0103		;ST2
	iny
	cpy #9*3
	bne ScreenInitAgain
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
;	Init Palette

	stz $0402			;Palette address L
	stz $0403			;Palette address H
	cly
SetPaletteAgain:
	lda Palette,y
	iny
	sta $0404			;GGRRRBBB
	lda Palette,y
	sta $0405			;-------G
	iny
	cpy #15*2
	bne SetPaletteAgain
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	

;Clear the whole tilemap

	st0 #0			;VDP reg 0 (address)
	st1 #$00		;L - Start of tilemap $0000
	st2 #$00		;H
	
	st0 #2			;Select VDP Reg2 (data)	
	
	ldx #4
	cly ;ldy #0		;1024 tiles total (32x32)
ClsAgain:	
	st1 #0			;Fill the entire area with our "Space tile"
	st2 #%00000001	;(tile 256)
	dey
	bne ClsAgain
	dex 
	bne ClsAgain
	
	
;Draw the bitmap Tilemap
	stz z_b
	lda #2				;Start SY
	sta z_c
	
	ldx #32				;Width in tiles
	ldy #24				;Height in tiles
		
	stz z_l
	lda #$04
	sta z_h				;TileStart 1024+
	
	st0 #0
	st1 #$40			;VideoL
	st2 #0				;VideoH
	
	st0 #2

; z_b = SX... z_c = SY... X=Width... Y= Height... HL=start tile
FillAreaWithTiles_Yagain:
	phx
		
		lda z_d
FillAreaWithTiles_Xagain:	;Save the TileNum to Vram
		lda z_l
		sta $0102			;L Byte
		lda z_h
		sta $0103			;H Byte - Tile 256+
		clc
		jsr IncHL			;Increase Tile Number
		dex 
		bne FillAreaWithTiles_Xagain
		inc z_c				;Inc Ypos
	plx
	dey						;Decrease Y count
	bne FillAreaWithTiles_Yagain
	
	jsr ClearRam		;Run Adventure engine ram clear and CLS

	jmp ContinueProg	;The reset vector is at a fixed address GRR!
						; Here we skip over it to our game code.


ScreenInit:		;Param,Byte 1,Byte 2
	db $05,$80,$00	;CR		Control (Background ON)
	db $07,$00,$00	;BXR	BGX Scroll
	db $08,$F8,$00	;BYR	BGY Scroll	
	db $09,$00,$00	;MWR	Memory Access Width 
	db $0A,$02,$02	;HSR	Horizontal Sync 
	db $0B,$1F,$03	;HDR	Horizontal Display
	db $0C,$02,$0F	;VPR	Vertical Sync
	db $0D,$EF,$00	;BDW	Vertical Display
	db $0E,$03,$00	;BCR	Vertical Display End Position
	

Bitmapfont:					
	ifdef PCE_Use4ColorFont
		ds 16	;Space
		db $10,$10,$08,$18,$00,$18,$00,$18,$00,$18,$00,$00,$10,$08,$00,$00     ;  0
		db $28,$28,$28,$6C,$00,$28,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;  2
		db $00,$00,$28,$28,$00,$7C,$00,$28,$54,$28,$28,$00,$00,$00,$00,$00     ;  4
		db $18,$18,$2A,$3E,$00,$48,$00,$3C,$00,$12,$54,$28,$18,$00,$00,$00     ;  6
		db $02,$02,$80,$C4,$00,$C8,$00,$10,$00,$20,$44,$02,$86,$00,$00,$00     ;  8
		db $10,$10,$28,$28,$00,$28,$00,$72,$00,$94,$04,$88,$72,$00,$00,$00     ; 10
		db $0C,$0C,$08,$1C,$00,$30,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 12
		db $18,$18,$08,$18,$00,$30,$00,$30,$00,$30,$10,$08,$18,$00,$00,$00     ; 14
		db $18,$18,$08,$18,$00,$0C,$00,$0C,$00,$0C,$10,$08,$18,$00,$00,$00     ; 16
		db $08,$08,$41,$49,$00,$2A,$00,$1C,$00,$14,$00,$22,$41,$00,$00,$00     ; 18
		db $00,$00,$08,$18,$00,$18,$00,$7E,$00,$18,$10,$08,$00,$00,$00,$00     ; 20
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$10,$08,$18,$00,$30,$00     ; 22
		db $00,$00,$00,$00,$00,$00,$00,$7E,$7E,$00,$00,$00,$00,$00,$00,$00     ; 24
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$10,$08,$18,$00,$00,$00     ; 26
		db $02,$02,$00,$04,$00,$08,$00,$10,$00,$20,$40,$00,$80,$00,$00,$00     ; 28
		db $7C,$7C,$82,$C6,$00,$D6,$00,$D6,$92,$44,$C6,$00,$7C,$00,$00,$00     ; 30
		db $10,$10,$08,$18,$00,$18,$00,$18,$00,$18,$10,$08,$08,$00,$00,$00     ; 32
		db $3C,$3C,$2A,$7E,$00,$06,$00,$3C,$00,$60,$54,$2A,$3C,$00,$00,$00     ; 34
		db $3C,$3C,$2A,$7E,$00,$06,$00,$1C,$00,$06,$54,$2A,$3C,$00,$00,$00     ; 36
		db $18,$18,$28,$3C,$00,$64,$00,$CC,$00,$7C,$04,$08,$08,$00,$00,$00     ; 38
		db $3C,$3C,$2A,$7E,$00,$60,$00,$7C,$00,$06,$54,$2A,$3E,$00,$00,$00     ; 40
		db $3C,$3C,$2A,$7E,$00,$60,$00,$7C,$00,$66,$44,$22,$3C,$00,$00,$00     ; 42
		db $3C,$3C,$2A,$7E,$00,$06,$00,$0C,$00,$18,$10,$08,$10,$00,$00,$00     ; 44
		db $3C,$3C,$22,$66,$00,$66,$00,$3C,$00,$66,$44,$22,$3C,$00,$00,$00     ; 46
		db $3C,$3C,$22,$66,$00,$66,$00,$3E,$00,$06,$54,$2A,$3C,$00,$00,$00     ; 48
		db $00,$00,$00,$00,$18,$18,$00,$18,$00,$00,$10,$08,$18,$00,$00,$00     ; 50
		db $00,$00,$00,$00,$18,$18,$00,$18,$00,$00,$10,$08,$18,$00,$30,$00     ; 52
		db $0C,$0C,$08,$1C,$00,$38,$00,$60,$00,$38,$14,$08,$0C,$00,$00,$00     ; 54
		db $00,$00,$00,$00,$2A,$7E,$00,$00,$00,$00,$54,$2A,$00,$00,$00,$00     ; 56
		db $60,$60,$20,$70,$00,$38,$00,$0C,$00,$38,$50,$20,$60,$00,$00,$00     ; 58
		db $3C,$3C,$22,$76,$00,$06,$00,$1C,$00,$00,$08,$10,$18,$00,$00,$00     ; 60
		db $7C,$7C,$82,$CE,$00,$A6,$00,$B6,$02,$C4,$50,$A0,$7C,$00,$00,$00     ; 62
		db $18,$18,$28,$3C,$00,$66,$00,$66,$00,$7E,$44,$22,$24,$00,$00,$00     ; 64
		db $3C,$3C,$22,$66,$00,$66,$00,$7C,$00,$66,$44,$22,$3C,$00,$00,$00     ; 66
		db $38,$38,$28,$7C,$00,$C0,$00,$C0,$00,$C0,$54,$28,$38,$00,$00,$00     ; 68
		db $3C,$3C,$20,$64,$00,$66,$00,$66,$00,$66,$44,$20,$38,$00,$00,$00     ; 70
		db $3C,$3C,$2A,$7E,$00,$60,$00,$78,$00,$60,$54,$2A,$3C,$00,$00,$00     ; 72
		db $38,$38,$28,$7C,$00,$60,$00,$78,$00,$60,$40,$20,$20,$00,$00,$00     ; 74
		db $3C,$3C,$22,$66,$00,$C0,$00,$C0,$00,$CC,$44,$22,$3C,$00,$00,$00     ; 76
		db $24,$24,$22,$66,$00,$66,$00,$7E,$00,$66,$44,$22,$24,$00,$00,$00     ; 78
		db $10,$10,$08,$18,$00,$18,$00,$18,$00,$18,$10,$08,$08,$00,$00,$00     ; 80
		db $08,$08,$08,$0C,$00,$0C,$00,$0C,$00,$4C,$54,$A8,$78,$00,$00,$00     ; 82
		db $24,$24,$22,$66,$00,$6C,$00,$78,$00,$6C,$44,$22,$24,$00,$00,$00     ; 84
		db $20,$20,$20,$60,$00,$60,$00,$60,$00,$60,$54,$2A,$3E,$00,$00,$00     ; 86
		db $44,$44,$AA,$EE,$00,$FE,$00,$D6,$00,$D6,$44,$92,$44,$00,$00,$00     ; 88
		db $44,$44,$A2,$E6,$00,$F6,$00,$DE,$00,$CE,$44,$82,$44,$00,$00,$00     ; 90
		db $38,$38,$28,$6C,$00,$C6,$00,$C6,$00,$C6,$44,$28,$38,$00,$00,$00     ; 92
		db $38,$38,$20,$6C,$00,$64,$00,$7C,$00,$60,$40,$20,$20,$00,$00,$00     ; 94
		db $38,$38,$28,$6C,$00,$C6,$00,$C6,$00,$CA,$74,$00,$3A,$00,$00,$00     ; 96
		db $3C,$3C,$22,$66,$00,$66,$00,$7C,$00,$6C,$44,$22,$26,$00,$00,$00     ; 98
		db $3C,$3C,$22,$7E,$00,$60,$00,$3C,$00,$06,$54,$2A,$3C,$00,$00,$00     ;100
		db $3C,$3C,$2A,$7E,$00,$18,$00,$18,$00,$18,$10,$08,$08,$00,$00,$00     ;102
		db $24,$24,$22,$66,$00,$66,$00,$66,$00,$66,$44,$22,$3C,$00,$00,$00     ;104
		db $24,$24,$22,$66,$00,$66,$00,$66,$00,$66,$14,$28,$18,$00,$00,$00     ;106
		db $44,$44,$82,$C6,$00,$D6,$00,$D6,$00,$FE,$AA,$44,$44,$00,$00,$00     ;108
		db $C6,$C6,$28,$6C,$00,$38,$00,$38,$00,$6C,$44,$82,$44,$00,$00,$00     ;110
		db $24,$24,$22,$66,$00,$66,$00,$3C,$00,$18,$10,$08,$08,$00,$00,$00     ;112
		db $7C,$7C,$A8,$FC,$00,$0C,$00,$18,$00,$30,$54,$2A,$7C,$00,$00,$00     ;114
		db $1C,$1C,$20,$30,$00,$30,$00,$30,$00,$30,$10,$20,$1C,$00,$00,$00     ;116
		db $80,$80,$00,$40,$00,$20,$00,$10,$00,$08,$04,$00,$02,$00,$00,$00     ;118
		db $38,$38,$08,$0C,$00,$0C,$00,$0C,$00,$0C,$04,$08,$38,$00,$00,$00     ;120
		db $18,$18,$28,$3C,$00,$7E,$00,$18,$00,$18,$10,$08,$18,$00,$00,$00     ;122
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$FF,$00,$FF,$00     ;124
		db $30,$30,$08,$18,$00,$0C,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;126
		db $00,$00,$00,$00,$00,$38,$00,$0C,$00,$7C,$44,$88,$78,$00,$00,$00     ;128
	else
		ds 32
		db $10,$10,$08,$18,$00,$18,$00,$18,$00,$18,$00,$00,$10,$08,$00,$00     ;  0
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;  1
		db $28,$28,$28,$6C,$00,$28,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;  2
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;  3
		db $00,$00,$28,$28,$00,$7C,$00,$28,$54,$28,$28,$00,$00,$00,$00,$00     ;  4
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;  5
		db $18,$18,$2A,$3E,$00,$48,$00,$3C,$00,$12,$54,$28,$18,$00,$00,$00     ;  6
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;  7
		db $02,$02,$80,$C4,$00,$C8,$00,$10,$00,$20,$44,$02,$86,$00,$00,$00     ;  8
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;  9
		db $10,$10,$28,$28,$00,$28,$00,$72,$00,$94,$04,$88,$72,$00,$00,$00     ; 10
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 11
		db $0C,$0C,$08,$1C,$00,$30,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 12
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 13
		db $18,$18,$08,$18,$00,$30,$00,$30,$00,$30,$10,$08,$18,$00,$00,$00     ; 14
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 15
		db $18,$18,$08,$18,$00,$0C,$00,$0C,$00,$0C,$10,$08,$18,$00,$00,$00     ; 16
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 17
		db $08,$08,$41,$49,$00,$2A,$00,$1C,$00,$14,$00,$22,$41,$00,$00,$00     ; 18
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 19
		db $00,$00,$08,$18,$00,$18,$00,$7E,$00,$18,$10,$08,$00,$00,$00,$00     ; 20
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 21
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$10,$08,$18,$00,$30,$00     ; 22
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 23
		db $00,$00,$00,$00,$00,$00,$00,$7E,$7E,$00,$00,$00,$00,$00,$00,$00     ; 24
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 25
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$10,$08,$18,$00,$00,$00     ; 26
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 27
		db $02,$02,$00,$04,$00,$08,$00,$10,$00,$20,$40,$00,$80,$00,$00,$00     ; 28
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 29
		db $7C,$7C,$82,$C6,$00,$D6,$00,$D6,$92,$44,$C6,$00,$7C,$00,$00,$00     ; 30
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 31
		db $10,$10,$08,$18,$00,$18,$00,$18,$00,$18,$10,$08,$08,$00,$00,$00     ; 32
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 33
		db $3C,$3C,$2A,$7E,$00,$06,$00,$3C,$00,$60,$54,$2A,$3C,$00,$00,$00     ; 34
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 35
		db $3C,$3C,$2A,$7E,$00,$06,$00,$1C,$00,$06,$54,$2A,$3C,$00,$00,$00     ; 36
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 37
		db $18,$18,$28,$3C,$00,$64,$00,$CC,$00,$7C,$04,$08,$08,$00,$00,$00     ; 38
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 39
		db $3C,$3C,$2A,$7E,$00,$60,$00,$7C,$00,$06,$54,$2A,$3E,$00,$00,$00     ; 40
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 41
		db $3C,$3C,$2A,$7E,$00,$60,$00,$7C,$00,$66,$44,$22,$3C,$00,$00,$00     ; 42
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 43
		db $3C,$3C,$2A,$7E,$00,$06,$00,$0C,$00,$18,$10,$08,$10,$00,$00,$00     ; 44
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 45
		db $3C,$3C,$22,$66,$00,$66,$00,$3C,$00,$66,$44,$22,$3C,$00,$00,$00     ; 46
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 47
		db $3C,$3C,$22,$66,$00,$66,$00,$3E,$00,$06,$54,$2A,$3C,$00,$00,$00     ; 48
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 49
		db $00,$00,$00,$00,$18,$18,$00,$18,$00,$00,$10,$08,$18,$00,$00,$00     ; 50
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 51
		db $00,$00,$00,$00,$18,$18,$00,$18,$00,$00,$10,$08,$18,$00,$30,$00     ; 52
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 53
		db $0C,$0C,$08,$1C,$00,$38,$00,$60,$00,$38,$14,$08,$0C,$00,$00,$00     ; 54
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 55
		db $00,$00,$00,$00,$2A,$7E,$00,$00,$00,$00,$54,$2A,$00,$00,$00,$00     ; 56
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 57
		db $60,$60,$20,$70,$00,$38,$00,$0C,$00,$38,$50,$20,$60,$00,$00,$00     ; 58
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 59
		db $3C,$3C,$22,$76,$00,$06,$00,$1C,$00,$00,$08,$10,$18,$00,$00,$00     ; 60
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 61
		db $7C,$7C,$82,$CE,$00,$A6,$00,$B6,$02,$C4,$50,$A0,$7C,$00,$00,$00     ; 62
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 63
		db $18,$18,$28,$3C,$00,$66,$00,$66,$00,$7E,$44,$22,$24,$00,$00,$00     ; 64
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 65
		db $3C,$3C,$22,$66,$00,$66,$00,$7C,$00,$66,$44,$22,$3C,$00,$00,$00     ; 66
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 67
		db $38,$38,$28,$7C,$00,$C0,$00,$C0,$00,$C0,$54,$28,$38,$00,$00,$00     ; 68
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 69
		db $3C,$3C,$20,$64,$00,$66,$00,$66,$00,$66,$44,$20,$38,$00,$00,$00     ; 70
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 71
		db $3C,$3C,$2A,$7E,$00,$60,$00,$78,$00,$60,$54,$2A,$3C,$00,$00,$00     ; 72
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 73
		db $38,$38,$28,$7C,$00,$60,$00,$78,$00,$60,$40,$20,$20,$00,$00,$00     ; 74
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 75
		db $3C,$3C,$22,$66,$00,$C0,$00,$C0,$00,$CC,$44,$22,$3C,$00,$00,$00     ; 76
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 77
		db $24,$24,$22,$66,$00,$66,$00,$7E,$00,$66,$44,$22,$24,$00,$00,$00     ; 78
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 79
		db $10,$10,$08,$18,$00,$18,$00,$18,$00,$18,$10,$08,$08,$00,$00,$00     ; 80
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 81
		db $08,$08,$08,$0C,$00,$0C,$00,$0C,$00,$4C,$54,$A8,$78,$00,$00,$00     ; 82
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 83
		db $24,$24,$22,$66,$00,$6C,$00,$78,$00,$6C,$44,$22,$24,$00,$00,$00     ; 84
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 85
		db $20,$20,$20,$60,$00,$60,$00,$60,$00,$60,$54,$2A,$3E,$00,$00,$00     ; 86
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 87
		db $44,$44,$AA,$EE,$00,$FE,$00,$D6,$00,$D6,$44,$92,$44,$00,$00,$00     ; 88
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 89
		db $44,$44,$A2,$E6,$00,$F6,$00,$DE,$00,$CE,$44,$82,$44,$00,$00,$00     ; 90
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 91
		db $38,$38,$28,$6C,$00,$C6,$00,$C6,$00,$C6,$44,$28,$38,$00,$00,$00     ; 92
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 93
		db $38,$38,$20,$6C,$00,$64,$00,$7C,$00,$60,$40,$20,$20,$00,$00,$00     ; 94
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 95
		db $38,$38,$28,$6C,$00,$C6,$00,$C6,$00,$CA,$74,$00,$3A,$00,$00,$00     ; 96
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 97
		db $3C,$3C,$22,$66,$00,$66,$00,$7C,$00,$6C,$44,$22,$26,$00,$00,$00     ; 98
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 99
		db $3C,$3C,$22,$7E,$00,$60,$00,$3C,$00,$06,$54,$2A,$3C,$00,$00,$00     ;100
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;101
		db $3C,$3C,$2A,$7E,$00,$18,$00,$18,$00,$18,$10,$08,$08,$00,$00,$00     ;102
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;103
		db $24,$24,$22,$66,$00,$66,$00,$66,$00,$66,$44,$22,$3C,$00,$00,$00     ;104
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;105
		db $24,$24,$22,$66,$00,$66,$00,$66,$00,$66,$14,$28,$18,$00,$00,$00     ;106
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;107
		db $44,$44,$82,$C6,$00,$D6,$00,$D6,$00,$FE,$AA,$44,$44,$00,$00,$00     ;108
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;109
		db $C6,$C6,$28,$6C,$00,$38,$00,$38,$00,$6C,$44,$82,$44,$00,$00,$00     ;110
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;111
		db $24,$24,$22,$66,$00,$66,$00,$3C,$00,$18,$10,$08,$08,$00,$00,$00     ;112
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;113
		db $7C,$7C,$A8,$FC,$00,$0C,$00,$18,$00,$30,$54,$2A,$7C,$00,$00,$00     ;114
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;115
		db $1C,$1C,$20,$30,$00,$30,$00,$30,$00,$30,$10,$20,$1C,$00,$00,$00     ;116
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;117
		db $80,$80,$00,$40,$00,$20,$00,$10,$00,$08,$04,$00,$02,$00,$00,$00     ;118
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;119
		db $38,$38,$08,$0C,$00,$0C,$00,$0C,$00,$0C,$04,$08,$38,$00,$00,$00     ;120
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;121
		db $18,$18,$28,$3C,$00,$7E,$00,$18,$00,$18,$10,$08,$18,$00,$00,$00     ;122
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;123
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$FF,$00,$FF,$00     ;124
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;125
		db $30,$30,$08,$18,$00,$0C,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;126
		db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;127
		db $00,$00,$00,$00,$00,$38,$00,$0C,$00,$7C,$44,$88,$78,$00,$00,$00     ;128
	endif
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	

Palette:
    dw %0000000000000000	; 0  %-------GGGRRRBBB
    dw %0000000000100100	; 1  %-------GGGRRRBBB
    dw %0000000111000111	; 2  %-------GGGRRRBBB
    dw %0000000111111111	; 3  %-------GGGRRRBBB
    dw %0000000000100010	; 4  %-------GGGRRRBBB
    dw %0000000100000100	; 5  %-------GGGRRRBBB
    dw %0000000100100111	; 6  %-------GGGRRRBBB
    dw %0000000000111000	; 7  %-------GGGRRRBBB
    dw %0000000111000010	; 8  %-------GGGRRRBBB
    dw %0000000011111110	; 9  %-------GGGRRRBBB
    dw %0000000100100111	;10  %-------GGGRRRBBB
    dw %0000000000000111	;11  %-------GGGRRRBBB
    dw %0000000100000000	;12  %-------GGGRRRBBB
    dw %0000000111101011	;13  %-------GGGRRRBBB
    dw %0000000000111100	;14  %-------GGGRRRBBB
    dw %0000000111111111	;15  %-------GGGRRRBBB
	

slowdown:	;this exists for systems that run too fast
	nop
	nop
	nop
	nop
	nop
	nop
	rts

NewLine:
	lda #0		
	sta z_d			;Cursor X=0

	inc z_e			;Cursor Y++

	lda z_e
	cmp #23			;At bottom of screen?
	bcs cls			;no? return, else cls!
	rts
	
Cls:
	lda z_h
	pha
	lda z_l
	pha
		lda z_b
		pha
		lda z_c
		pha
			lda #0
			sta z_d			;x,y
			sta z_e
			sta z_l			;char,inc
			lda #$20
			sta z_h

			lda #$28		;width,height
			sta z_b
			lda #$19
			sta z_c

			jsr fillarea	;Clear the screen
		pla
		sta	z_c
		pla
		sta z_b
	pla
	sta	z_l
	pla
	sta z_h
	rts

	
printnumber:		;print char a at loc de
	clc
	adc #48			;ascii 0
	
printchar:			;print char a with sprite routine	
	cmp #0
	beq printchar0	;0=Skip this char
	tax
	
	lda z_h
	pha
	lda z_l
	pha
		txa
		sec
		sbc #32		;no char below 32
		cmp #64		;Lowercase?
		bcc notlowercase
		sec			
		sbc #32		;Convert to upper!
notlowercase:
		pha
			stz z_l
					
			lda z_d		;Xpos
			lsr 
			ror z_l		;*128
			lsr 
			ror z_l		;*64
			lsr 
			ror z_l		;*32
			lsr 
			ror z_l		;*16 (32 bytes per tile )
			sta z_h		;    ( 2 bytes per VRAM Address)
			
			lda z_e		;Ypos (32 tiles per line *32 bytesPerTile)
			asl			;*512 (  =1024/2 =512 )
			clc
			adc z_h
			adc #$40		;Tile 1024+
			sta z_h
			
			st0 #0			;Select Vram Write
			
			lda z_l
			sta $0102		;Send to Data-L
			lda z_h
			sta $0103		;Send to Data-H
			
			st0 #2			;Set Write Register
		pla
		
;Calculate Bitmap Source
		sta z_h
		lda #0
		lsr z_h			;*128
		ror
		lsr z_h			;*64
		ror
		lsr z_h			;*32
		ror
		ifdef PCE_Use4ColorFont
			lsr z_h			;*16
			ror
		endif
		adc #<Bitmapfont
		sta z_l
		lda z_h
		adc #>Bitmapfont
		sta z_h		
		
;Send Pattern data		
		ldy #0
printchar_SendBitmap:		
		
		lda (z_hl),y
		sta $0102			;Store Char 
		iny
		lda (z_hl),y
		sta $0103
		iny
		ifdef PCE_Use4ColorFont
			cpy #16				;16 bytes per char in 4 color mode
		else
			cpy #32				;32 bytes per char in 16 color mode
		endif
		bne printchar_SendBitmap
		
		ifdef PCE_Use4ColorFont
printchar_SendBitmapZero:		
		
			st1 #0				;Bitplanes 2/3 unused in 4 color mode
			dey
			st2 #0
			dey
			bne printchar_SendBitmapZero		
		endif
	pla
	sta z_l
	pla 
	sta z_h
	
	txa
printchar0:
	inc z_d				;Xpos ++
	rts

	
	
ReadJoystick:	;Returns %RSBARLDU
	ldx #%00000001			;Reset Multitap 1
	jsr JoypadSendCommand
	ldx #%00000011			;Reset Multitap 2
	jsr JoypadSendCommand
	
;Read Pad 1
	ldx #%00000001				
	jsr JoypadSendCommand	;%----LDRU (Left/Down/Right/Up)
	ror						;Up
	ror z_as		
	ror						;Right (for later)
	php	
		ror					;Down
		ror z_as
		ror					;Left
		ror z_as
	plp						;Get Right
	ror z_as
	
	dex		;X=0
	jsr JoypadSendCommand	;%---RSBA (Run/Start/B/A)
	ldx #4
JoypadShiftFourBitsB:
	ror
	ror z_as				;Shift to top 4 bits
	dex
	bne JoypadShiftFourBitsB
	
	lda z_as				;Get Result %RSBALDRU
	rts
		
JoypadSendCommand:
	stx $1000			;Set option from X
	pha 				
	pla					;Delay
	nop 
	nop
	lda $1000			;Load result
	rts

	
;5680 bytes ($1630) free in this spot when using 16 color font

	ifndef PCE_DontDefineResetVector ;Enable this if you want to
		org $5ffe					 ; Define the reset vector yourself
		dw $E000					 ;Reset Vector must be at this point
	endif
	
ContinueProg: