

z_Regs equ $20			;Used for fake Z80 register pairs

ramarea equ $200		;Define some space for program vars
						;First 16 bytes reserved for core.
						;$6000-7FFF is in cartridge RAM
						
						
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;For Bitmap Screen  	Screen size=200x160 25x20 tiles
; First 80 lines at $6000, rest at $7000 10x25=250 tiles of each map used.

RamAddrL	equ $82		;Address of Cache to copy - only 8 tiles 
RamAddrH	equ $83			;copied per NMI

;Three tile patterns that are updated every frame 

FastRefresh1_L equ $90
FastRefresh1_H equ $91

FastRefresh2_L equ $92
FastRefresh2_H equ $93

FastRefresh3_L equ $94
FastRefresh3_H equ $95


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	

						
;For Tilemap Buffer

	ifdef NES_UseTileBuffer
VDP_L equ z_Regs+18			;Position of next Tile in buffer L
VDP_H equ z_Regs+19			;Position of next Tile in buffer H
VDP_Update equ z_Regs+20	;VDP Update Flag
VDPBuffer equ $200			;$400 byte Tilemap Buffer
	endif

;For Sprite Buffer	
	
	ifdef NES_UseSpriteBuffer
SpriteBuffer equ $600	;$100 byte Sprite data (64 sprites)
	endif
	
vblanked 	equ $7F		;Zero page address of Vblank count
ScreenOn	equ $80		;Remeber if screen is on


	org $BFF0

	db "NES",$1a		;ID
	db $01				;Rom pages (16k each)
	db $0				;CHR-ROM pages
	db %01000010		;mmmmFTBM		mmmm = mapper no bottom 4 bits , Four screen vram layout, Trainer at &7000, Battery ram at &6000, Mirror (0=horiz, 1=vert)
	db %00000000		;mmmm--PV 		mapper (top 4 bits...  Pc10 arcade, Vs unisystem )
	db 0				;Ram pages
	db 0,0,0,0,0,0,0
	
;We selected Mapper 4 - it has 8k VRAM , 8K Sram and 128k rom
	
ProgramStart:
	sei					;Interrupts off
	cld					;Clear Decimal flag
	
	ldx #$ff			;Set up stack
	txs

	jsr NesDisableScreen

	lda #%10000000	;Turn on extra ram at $6000-%7FFF
	sta $A001
	
	
	;lda #3			;%-------M - Enable H/V mirroring of tilemap
	;sta $A000		; (So only NameTable 0 is used)
				
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		
;Fill unused areas with spare tile (255)

	lda #$20
	sta $2006
	lda #$0
	sta $2006				;Select start of Tilemap ($2000+)
	
	ldx #4*2
	tay ;ldy #0				;Fill Tilemaps 0,1
TileFill:
	lda #255
	sta $2007				;Fill Tilemap with tile 255 (Blank)
	dey 
	bne TileFill
	dex
	bne TileFill
	
;Set the Tilemaps (0-250) (First 80 lines)

	lda #4					;Start SX
	sta z_d
	lda #4+1				;Start SY
	sta z_e
	jsr FillAreaWithTilesBMP ;Draw the tiles to screen
	
;Set the Tilemaps (256-506) (2nd 80 lines)
	
	jsr FillAreaWithTilesBMP ;Draw the tiles to screen
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		
	
;Set Color Attributes
	lda #$23		
	sta $2006			;PPUADDR H ($23C0)
	ldx #$C0
	stx $2006			;PPUADDR L
	
	lda #0
SetAttributeAgain:
	sta $2007
	inx
	bne SetAttributeAgain	;Repeat until $2400
	
;Palette
	lda #$3F			;Select Palette ram &3F00
	sta $2006			;PPUADDR H
	;txa ;X=0	
	stx $2006			;PPUADDR L
	
	ldx #4
PaletteAgain
	lda Palette-1,x 
	sta $2007			;PPUDATA
	dex 
	bne PaletteAgain
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	

;Define bitmap screen vars
	
	stx RamAddrL		;Reset copy ranges. (X=0)
	
	stx FastRefresh1_L	;These can be used to refresh 3 tiles 
	stx FastRefresh1_H	; each tick
	stx FastRefresh2_L
	stx FastRefresh2_H
	stx FastRefresh3_L
	stx FastRefresh3_H
	
	lda #$60
	sta RamAddrH		;Base of cache
		
	lda #%11000000		;Sound IRQ off
	sta $4017
		
	jsr NesEnableScreen	;Turn ON the screen
	
	cli					;Enable interrupts
			
	jsr ClearRam		;Run Adventure engine ram clear and CLS
	