

z_Regs equ $20			;Used for fake Z80 register pairs

ramarea equ $6000		;Define some space for program vars
						;First 16 bytes reserved for core.
						;$6000-7FFF is in cartridge RAM
;For Tilemap Buffer

	ifdef NES_UseTileBuffer
VDP_L equ z_Regs+18			;Position of next Tile in buffer L
VDP_H equ z_Regs+19			;Position of next Tile in buffer H
VDP_Update equ z_Regs+20	;VDP Update Flag
VDPBuffer equ $200			;$400 byte Tilemap Buffer
	endif

;For Sprite Buffer	
	
	ifdef NES_UseSpriteBuffer
SpriteBuffer equ VDPBuffer+$400	;$100 byte Sprite data (64 sprites)
	endif
	
vblanked 	equ $7F		;Zero page address of Vblank count
ScreenOn	equ $80		;Remeber if screen is on



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	


	org $BFF0

	db "NES",$1a		;ID
	db $01				;Rom pages (16k each)
	db $0				;CHR-ROM pages
	db %01000010		;mmmmFTBM		mmmm = mapper no bottom 4 bits , Four screen vram layout, Trainer at &7000, Battery ram at &6000, Mirror (0=horiz, 1=vert)
	db %00000000		;mmmm--PV 		mapper (top 4 bits...  Pc10 arcade, Vs unisystem )
	db 0				;Ram pages
	db 0,0,0,0,0,0,0
	
;We selected Mapper 4 - it has 8k VRAM , 8K Sram and 128k rom
	
ProgramStart:
	sei					;Interrupts off
	cld					;Clear Decimal flag
	
	ldx #$ff			;Set up stack
	txs

	jsr NesDisableScreen

	lda #%10000000	;Turn on extra ram at $6000-%7FFF
	sta $A001
	
	ifdef VDPBuffer
		lda #$40 		;Init VDP buffer params
		sta VDP_L
		lda #>VDPBuffer
		sta VDP_H
	endif
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	


;Define the font
	ldy #0			;Pattern table &0000
	sty $2006		;PPUADDR H
	sty $2006		;PPUADDR L

	lda #BitmapFont&255	;Address of font
	sta z_L
	lda #BitmapFont/256
	sta z_H
		
	ldx #4		;z_as=H byte Y=Lbyte of count
	;sta z_as 	; Y=0 ($400=1024 lines total)
	
fontchar_loop:		
	;ldx #16			;8 bytes per tile bitplane
FontFillAgain_Plane1:	
	lda (z_HL),y
	sta $2007		;Write data to data-port 
	iny
	;dex 
	;bne FontFillAgain_Plane1
		
	;tya
	bne fontchar_loop		;Repeat until Y=0
	inc z_H
	dex
	bne fontchar_loop
	

;Set Color Attributes
	lda #$23		
	sta $2006		;PPUADDR H ($23C0)
	ldx #$C0
	stx $2006		;PPUADDR L
	
	lda #0
SetAttributeAgain:
	sta $2007
	inx
	bne SetAttributeAgain	;Repeat until $2400
		
	
;Palette
	lda #$3F		;Select Palette ram &3F00
	sta $2006		;PPUADDR H
	txa ;X=0
	sta $2006		;PPUADDR L
	
	ldx #4
PaletteAgain
	lda Palette-1,x 
	sta $2007		;PPUDATA
	dex 
	bne PaletteAgain

	
	jsr NesEnableScreen		;Turn ON the screen
	
	jsr ClearRam			;Run Adventure engine ram clear and CLS
	