

		
newline:
	lda #0		;new line
	sta z_d

	inc z_e

	lda z_e
	cmp #19			;at bottom of screen
	bcs cls		;no? return, else cls!
Slowdown:
	rts

cls:
	lda z_h
	pha
	lda z_l
	pha
	lda z_b
	pha
	lda z_c
	pha
		lda #0
		sta z_d			;Xpos
		sta z_e			;Ypos
		
		sta z_l			;CharInc
		lda #$20
		sta z_h			;Char

		lda #32			
		sta z_b			;Width
		lda #24			
		sta z_c			;Height
		jsr fillarea
	pla
	sta	z_c
	pla
	sta z_b
	pla
	sta	z_l
	pla
	sta z_h
	rts
	
	
printnumber:	
	clc
	adc #48			;ascii 0
printchar:			;print character A to location D E
	cmp #0
	bne Notprintchar0
	inc z_d				;Char 0 = Just inc Xpos
	rts
Notprintchar0:	

	tax
	pushpair z_hl
	pushpair z_bc
	;pushpair z_de
;Calculate VRAM Dest (Hl)
		ldy #0
		jsr CalcVramAddr
		
;Get source font character (BC)
		txa
		sec
		sbc #32				;no char below 32
		cmp #64
		bcc notlowercase	;Lowercase?
		sec
		sbc #32				;Convert to upper
notlowercase:
		sta z_b
		tya ;lda #0
		lsr z_b			;*128
		ror
		lsr z_b			;*64
		ror
		lsr z_b			;*32
		ror
		lsr z_b			;*16
		ror
		adc #<Bitmapfont
		sta z_c
		lda z_b
		adc #>Bitmapfont
		sta z_b		

;Store the character into the cache
		ldy #15
printchar_Draw:		
		lda (z_bc),y
		sta (z_hl),y
		dey
		bpl printchar_Draw
		
		txa
		cmp #32
		beq printchar_SkipBuffer	;Don't buffer space
		
;We can update 3 tiles every Vblank so put this one onto the 'stack'
		lda FastRefresh2_H
		sta FastRefresh3_H
		lda FastRefresh2_L
		sta FastRefresh3_L
		
		lda FastRefresh1_H
		sta FastRefresh2_H
		lda FastRefresh1_L
		sta FastRefresh2_L

		lda z_h
		sec
		sbc #$60
		sta FastRefresh1_H
		lda z_l
		sta FastRefresh1_L
printchar_SkipBuffer:
	;pullpair z_de	
	pullpair z_bc
	pullpair z_hl
	txa
	inc z_d					;Xpos++
	rts

	
	
	
CalcVramAddr:			;DE=X,Y pos
	sty z_l ;y=0
	lda #$60			;Using Ram area $6000+ as a cache
	sta z_h
	
	lda z_e
	cmp #80/8			;lines >80 are in second pattern bank
	bcc ScreenFirstHalf
	
	lda #$60			;Skip the unused 6 tiles
	sta z_l
ScreenFirstHalf:	

	sty z_b	;y=0		;Address=$6000 + (Ypos*25*16) + Xpos*16
	lda z_d
	asl
	asl
	asl
	;and #%11111000		;8 lines - 2 bitplanes per line
	asl
	rol z_b
	sta z_c
	jsr addhl_bc
	
	sty z_b	;y=0
	lda z_e
	asl
	asl
	asl
	;and #%11111000		;*25*2 (25=1+8+16)
	asl
	rol z_b
	sta z_c
	jsr addhl_bc	;*2
	lda z_c
	asl
	rol z_b
	asl
	rol z_b
	asl
	rol z_b
	sta z_c
	jsr addhl_bc	;*8
	asl z_c
	rol z_b
	jmp addhl_bc	;*16
	


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

readjoystick:	;returns ;%SsBARLDU
	ldx #$01				;Send a 1 to joysticks (strobe reset)
	stx $4016				;JOYPAD1 port
	
	dex 					;Send a 0 to joysticks (read data)
	stx $4016				;JOYPAD1 port

	ldx #8					;Read in 8 bits from each joystick in order:
							;Right Left Down Up Start Select B A
Player_ReadControlsDualloop:
	lda $4016				;JOYPAD1
	lsr 	   				; bit0 -> Carry
	ror z_As  				;Add carry to Joy1 data
	dex 
	bne Player_ReadControlsDualloop
  
	lda z_As				;%RLDUSsBA
	eor #255				;Flip bits so unpressed=1
	
SwapNibbles:		;$AB -> $BA
	asl 		;(shift left - bottom bit zero)
	adc #$80 	;(pop top bit off - add carry)
	rol 		;(shift carry in)
	;2 bits moved
	asl 		;(shift left - bottom bit zero)
	adc #$80 	;(pop top bit off - add carry)
	rol 		;(shift carry in)
	rts			;4 bits moved

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
	
	
Palette:  
; 	Color   3   2   1  0
		db $30,$3C,$13,$0D
	
Bitmapfont:			;16 bytes per char (8 lines * 2 bitplanes)
	ds 16	;Space
	db $10,$08,$00,$00,$00,$00,$10,$00,$10,$18,$18,$18,$18,$00,$08,$00     ;  0
	db $28,$28,$00,$00,$00,$00,$00,$00,$28,$6C,$28,$00,$00,$00,$00,$00     ;  1
	db $00,$28,$00,$00,$54,$28,$00,$00,$00,$28,$7C,$28,$28,$00,$00,$00     ;  2
	db $18,$2A,$00,$00,$00,$54,$18,$00,$18,$3E,$48,$3C,$12,$28,$00,$00     ;  3
	db $02,$80,$00,$00,$00,$44,$86,$00,$02,$C4,$C8,$10,$20,$02,$00,$00     ;  4
	db $10,$28,$00,$00,$00,$04,$72,$00,$10,$28,$28,$72,$94,$88,$00,$00     ;  5
	db $0C,$08,$00,$00,$00,$00,$00,$00,$0C,$1C,$30,$00,$00,$00,$00,$00     ;  6
	db $18,$08,$00,$00,$00,$10,$18,$00,$18,$18,$30,$30,$30,$08,$00,$00     ;  7
	db $18,$08,$00,$00,$00,$10,$18,$00,$18,$18,$0C,$0C,$0C,$08,$00,$00     ;  8
	db $08,$41,$00,$00,$00,$00,$41,$00,$08,$49,$2A,$1C,$14,$22,$00,$00     ;  9
	db $00,$08,$00,$00,$00,$10,$00,$00,$00,$18,$18,$7E,$18,$08,$00,$00     ; 10
	db $00,$00,$00,$00,$00,$10,$18,$30,$00,$00,$00,$00,$00,$08,$00,$00     ; 11
	db $00,$00,$00,$00,$7E,$00,$00,$00,$00,$00,$00,$7E,$00,$00,$00,$00     ; 12
	db $00,$00,$00,$00,$00,$10,$18,$00,$00,$00,$00,$00,$00,$08,$00,$00     ; 13
	db $02,$00,$00,$00,$00,$40,$80,$00,$02,$04,$08,$10,$20,$00,$00,$00     ; 14
	db $7C,$82,$00,$00,$92,$C6,$7C,$00,$7C,$C6,$D6,$D6,$44,$00,$00,$00     ; 15
	db $10,$08,$00,$00,$00,$10,$08,$00,$10,$18,$18,$18,$18,$08,$00,$00     ; 16
	db $3C,$2A,$00,$00,$00,$54,$3C,$00,$3C,$7E,$06,$3C,$60,$2A,$00,$00     ; 17
	db $3C,$2A,$00,$00,$00,$54,$3C,$00,$3C,$7E,$06,$1C,$06,$2A,$00,$00     ; 18
	db $18,$28,$00,$00,$00,$04,$08,$00,$18,$3C,$64,$CC,$7C,$08,$00,$00     ; 19
	db $3C,$2A,$00,$00,$00,$54,$3E,$00,$3C,$7E,$60,$7C,$06,$2A,$00,$00     ; 20
	db $3C,$2A,$00,$00,$00,$44,$3C,$00,$3C,$7E,$60,$7C,$66,$22,$00,$00     ; 21
	db $3C,$2A,$00,$00,$00,$10,$10,$00,$3C,$7E,$06,$0C,$18,$08,$00,$00     ; 22
	db $3C,$22,$00,$00,$00,$44,$3C,$00,$3C,$66,$66,$3C,$66,$22,$00,$00     ; 23
	db $3C,$22,$00,$00,$00,$54,$3C,$00,$3C,$66,$66,$3E,$06,$2A,$00,$00     ; 24
	db $00,$00,$18,$00,$00,$10,$18,$00,$00,$00,$18,$18,$00,$08,$00,$00     ; 25
	db $00,$00,$18,$00,$00,$10,$18,$30,$00,$00,$18,$18,$00,$08,$00,$00     ; 26
	db $0C,$08,$00,$00,$00,$14,$0C,$00,$0C,$1C,$38,$60,$38,$08,$00,$00     ; 27
	db $00,$00,$2A,$00,$00,$54,$00,$00,$00,$00,$7E,$00,$00,$2A,$00,$00     ; 28
	db $60,$20,$00,$00,$00,$50,$60,$00,$60,$70,$38,$0C,$38,$20,$00,$00     ; 29
	db $3C,$22,$00,$00,$00,$08,$18,$00,$3C,$76,$06,$1C,$00,$10,$00,$00     ; 30
	db $7C,$82,$00,$00,$02,$50,$7C,$00,$7C,$CE,$A6,$B6,$C4,$A0,$00,$00     ; 31
	db $18,$28,$00,$00,$00,$44,$24,$00,$18,$3C,$66,$66,$7E,$22,$00,$00     ; 32
	db $3C,$22,$00,$00,$00,$44,$3C,$00,$3C,$66,$66,$7C,$66,$22,$00,$00     ; 33
	db $38,$28,$00,$00,$00,$54,$38,$00,$38,$7C,$C0,$C0,$C0,$28,$00,$00     ; 34
	db $3C,$20,$00,$00,$00,$44,$38,$00,$3C,$64,$66,$66,$66,$20,$00,$00     ; 35
	db $3C,$2A,$00,$00,$00,$54,$3C,$00,$3C,$7E,$60,$78,$60,$2A,$00,$00     ; 36
	db $38,$28,$00,$00,$00,$40,$20,$00,$38,$7C,$60,$78,$60,$20,$00,$00     ; 37
	db $3C,$22,$00,$00,$00,$44,$3C,$00,$3C,$66,$C0,$C0,$CC,$22,$00,$00     ; 38
	db $24,$22,$00,$00,$00,$44,$24,$00,$24,$66,$66,$7E,$66,$22,$00,$00     ; 39
	db $10,$08,$00,$00,$00,$10,$08,$00,$10,$18,$18,$18,$18,$08,$00,$00     ; 40
	db $08,$08,$00,$00,$00,$54,$78,$00,$08,$0C,$0C,$0C,$4C,$A8,$00,$00     ; 41
	db $24,$22,$00,$00,$00,$44,$24,$00,$24,$66,$6C,$78,$6C,$22,$00,$00     ; 42
	db $20,$20,$00,$00,$00,$54,$3E,$00,$20,$60,$60,$60,$60,$2A,$00,$00     ; 43
	db $44,$AA,$00,$00,$00,$44,$44,$00,$44,$EE,$FE,$D6,$D6,$92,$00,$00     ; 44
	db $44,$A2,$00,$00,$00,$44,$44,$00,$44,$E6,$F6,$DE,$CE,$82,$00,$00     ; 45
	db $38,$28,$00,$00,$00,$44,$38,$00,$38,$6C,$C6,$C6,$C6,$28,$00,$00     ; 46
	db $38,$20,$00,$00,$00,$40,$20,$00,$38,$6C,$64,$7C,$60,$20,$00,$00     ; 47
	db $38,$28,$00,$00,$00,$74,$3A,$00,$38,$6C,$C6,$C6,$CA,$00,$00,$00     ; 48
	db $3C,$22,$00,$00,$00,$44,$26,$00,$3C,$66,$66,$7C,$6C,$22,$00,$00     ; 49
	db $3C,$22,$00,$00,$00,$54,$3C,$00,$3C,$7E,$60,$3C,$06,$2A,$00,$00     ; 50
	db $3C,$2A,$00,$00,$00,$10,$08,$00,$3C,$7E,$18,$18,$18,$08,$00,$00     ; 51
	db $24,$22,$00,$00,$00,$44,$3C,$00,$24,$66,$66,$66,$66,$22,$00,$00     ; 52
	db $24,$22,$00,$00,$00,$14,$18,$00,$24,$66,$66,$66,$66,$28,$00,$00     ; 53
	db $44,$82,$00,$00,$00,$AA,$44,$00,$44,$C6,$D6,$D6,$FE,$44,$00,$00     ; 54
	db $C6,$28,$00,$00,$00,$44,$44,$00,$C6,$6C,$38,$38,$6C,$82,$00,$00     ; 55
	db $24,$22,$00,$00,$00,$10,$08,$00,$24,$66,$66,$3C,$18,$08,$00,$00     ; 56
	db $7C,$A8,$00,$00,$00,$54,$7C,$00,$7C,$FC,$0C,$18,$30,$2A,$00,$00     ; 57
	db $1C,$20,$00,$00,$00,$10,$1C,$00,$1C,$30,$30,$30,$30,$20,$00,$00     ; 58
	db $80,$00,$00,$00,$00,$04,$02,$00,$80,$40,$20,$10,$08,$00,$00,$00     ; 59
	db $38,$08,$00,$00,$00,$04,$38,$00,$38,$0C,$0C,$0C,$0C,$08,$00,$00     ; 60
	db $18,$28,$00,$00,$00,$10,$18,$00,$18,$3C,$7E,$18,$18,$08,$00,$00     ; 61
	db $00,$00,$00,$00,$00,$00,$FF,$FF,$00,$00,$00,$00,$00,$00,$00,$00     ; 62
	db $30,$08,$00,$00,$00,$00,$00,$00,$30,$18,$0C,$00,$00,$00,$00,$00     ; 63

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
	
NesDisableScreen:			;Turn OFF the screen
	jsr waitframe		;Wait for Vblank
		;%CCCSBsbM		;CCC=Color emphasis B=Background on S=Sprite on
	lda #%00000000		;s=sprite clip b=back clip M=monochrome		
	sta $2001			;PPUMASK
	;lda #$00			;NMI disable (Vblank)
	beq NesDisableScreenb
			
NesEnableScreen:			;Turn ON the screenY
		;%CCCSBsbM		;CCC=Color emphasis B=Background on S=Sprite on
	lda #%00001110 		;s=sprite clip b=back clip M=monochrome		
	sta $2001			;PPUMASK
	ifdef NES_Sprite8x16
			;%N-SBPIAA
		lda #%11011000	;NMI on (Vblank) + Sprite pat at $1000 + BigSprites+IRQ
	else
		lda #%10011000	;NMI on (Vblank) + Sprite patterns at $1000 + IRQ
	endif
NesDisableScreenb:
	sta $2000	;%N-SBPIAA	N=NMI on vblank  S=Spr size  B=Back Pat Tbl
				;			I=Inc vram addr  AA=Name Tbl addr P=spr Pat Tbl
	sta ScreenOn
	rts
	
	
waitframe:					;Wait for VBlank
	pha						;(NMI must update the vblaned zeropage)
		lda ScreenOn		; (entry)
		beq waitframeScreenOff
		lda #$00
		sta vblanked		;Zero Vblanked
waitloop:
		lda vblanked		;Wait for the interrupt to change it
		beq waitloop
waitframeScreenOff:
	pla
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
	
FillAreaWithTilesBMP:
	ldx #25					;Width in tiles
	ldy #10					;Height in tiles
	
	lda #0					;TileStart	
FillAreaWithTiles:
	sta z_h					;Backup tilenum
FillAreaWithTiles_Yagain:
	txa
	pha
		jsr GetVDPScreenPos	;Calculate Tilemap mempos
	
		lda z_h
FillAreaWithTiles_Xagain:
		sta $2007			;PPUDATA - Save Tile selection to Vram
		clc
		adc #1				;Move to next tile
		dex 
		bne FillAreaWithTiles_Xagain
		sta z_h
		inc z_e				;INC Ypos
	pla
	tax
	dey
	bne FillAreaWithTiles_Yagain
	rts					

GetVDPScreenPos:			;de=XYpos
	lda z_e
	asl
	asl
	asl
	asl
	asl
	ora z_d				;Add Xpos
	sta z_as			;Store in L byte
	lda z_e
	and #%11111000		;Other bits of Ypos for H byte
	lsr
	lsr
	lsr
	clc
	adc #$20			;$2000 ofset for base of tilemap
			
	sta $2006			;PPUADDR
	lda z_as
	sta $2006			;PPUADDR
	rts

	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
nmihandler:		;This procuedure runs after each frame
	pha			
	tya
	pha
	txa
	pha
		inc vblanked	;Alter Vblank Zero page entry
		
		lda RamAddrL	;Back up source address
		pha
			lda RamAddrH
			pha	
;3 Fast Refresh tiles
				lda FastRefresh1_H	
				ldx FastRefresh1_L
				jsr SetAndSendOneTile
				
				lda FastRefresh2_H	
				ldx FastRefresh2_L
				jsr SetAndSendOneTile
				
				lda FastRefresh3_H	
				ldx FastRefresh3_L
				jsr SetAndSendOneTile
			pla
			sta RamAddrH
			and #$1F
			sta $2006	;PPUADDR 	Destination address - H
		pla	
		sta $2006	
		sta RamAddrL	
		
;8 Sequential tiles	
		ldy #0
		ldx #8			;Transfer 8 tiles from chache to screen
CopyAgain		
		jsr SendOneTile
		dex
		bne CopyAgain	;Do Next Tile
		 
		tya
		clc
		adc RamAddrL	;Update address to continue next time
		sta RamAddrL
		 
		lda RamAddrH
		adc #0
		and #$1F		;$2000 per pattern bank
		ora #$60		;Cache starts at $6000
		sta RamAddrH

;Reset Scroll
		lda #4			;Scroll X
		sta $2005
		sta $2005		;Scroll y
		
;Set Top tilemap address
;We need to switch in other tileset for lower screen area.		
		lda #$80+$08	;Page in Tiles 0-255 (VRAM: $0000 RAMcache:$6000)
;Sprite address must be different to tile address or this will fail
		sta $2000		;PPUCTRL - VPHB SINN
				
;Prepare IRQ
		lda #116		;Screen middle line
		sta $C000   	;Set Line interrupt (Mapper 3 function)	
		sta $C001   	;Reset counter (Mapper 3 function)
		sta $E001   	;Enable IRQ (Mapper 3 function)
	pla
	tax
	pla
	tay
	pla
	rti
		

;Transfer Tile with VRAM address $AAXX	from cache
SetAndSendOneTile:		
	sta $2006			;VRAM destination 
	ora #$60			
	sta RamAddrH		;Ram address of Cache ($6000+)
			
	stx $2006		
	stx RamAddrL
	ldy #0
	
SendOneTile:
	lda (RamAddrL),y
	sta $2007
	iny
	lda (RamAddrL),y
	sta $2007
	iny
	lda (RamAddrL),y
	sta $2007
	iny
	lda (RamAddrL),y
	sta $2007
	iny
	lda (RamAddrL),y
	sta $2007
	iny
	lda (RamAddrL),y
	sta $2007
	iny
	lda (RamAddrL),y
	sta $2007
	iny
	lda (RamAddrL),y
	sta $2007
	iny
	lda (RamAddrL),y
	sta $2007
	iny
	lda (RamAddrL),y
	sta $2007
	iny
	lda (RamAddrL),y
	sta $2007
	iny
	lda (RamAddrL),y
	sta $2007
	iny
	lda (RamAddrL),y
	sta $2007
	iny
	lda (RamAddrL),y
	sta $2007
	iny
	lda (RamAddrL),y
	sta $2007
	iny
	lda (RamAddrL),y
	sta $2007
	iny
	rts	
	
	
irqhandler:				;Occurs at screen middle 
	pha
		lda #$80+$10	;Page in Tiles 256-511 (VRAM: 10000 RAMcache:$7000)
		sta $2000		;PPUCTRL - VPHB SINN
		sta $E000  		;Disable line interrupt
	pla
	rti	
	
;Cartridge Footer
	org $FFFA
	dw nmihandler			;FFFA - Interrupt handler
	dw ProgramStart			;FFFC - Entry point
	dw irqhandler			;FFFE - IRQ Handler
	
	
	
	