z_CursorX     	equ z_Regs+24
z_CursorY    	equ z_Regs+25
z_CursorA    	equ z_Regs+26

t_MemdumpL     	equ z_Regs+14
t_MemdumpH     	equ z_Regs+15

t_MemdumpBL     	equ z_Regs+16
t_MemdumpBH     	equ z_Regs+17

t_SP     	equ z_Regs+18
t_RetAddr 	equ z_Regs+19
t_RetAddrL 	equ z_Regs+19
t_RetAddrH 	equ z_Regs+20
t_A     	equ z_Regs+21
t_X     	equ z_Regs+22
t_Y     	equ z_Regs+23

z_ixl equ z_Regs+8
z_ixh equ z_Regs+9
z_ix equ z_Regs+8

z_iyl equ z_Regs+10
z_iyh equ z_Regs+11
z_iy  equ z_Regs+10

NewLineA:
	pha
		lda #0
		sta z_CursorX
		inc z_CursorY
	pla
	rts
	
PrintCharA:
	sta z_CursorA
	pha
	txa 
	pha
	tya 
	pha
	pushpair z_de
		lda z_CursorX
		sta z_d
		lda z_CursorY
		sta z_e
		
		lda z_CursorA
		jsr PrintChar
		
		lda z_d
		sta z_CursorX
		lda z_e
		sta z_CursorY
	pullpair z_de
	pla 
	tay
	pla
	tax
	pla
	rts
	
Showhex:
printhex:
        pha
                ror
                ror
                ror
                ror
                jsr printhexAgain
        pla
        pha        
                jsr printhexAgain
        pla
        rts
printhexAgain:
		and #%00001111
        cmp #10
        bcs printhex_OverNine
        clc
        adc #'0'
        jmp PrintCharA
printhex_OverNine:
        clc
        adc #55
        ;'adc #'A'
        jmp PrintCharA

;Usage:
;        jsr MemDump
;        word $CEED      ;Address
;        byte $3          ;Lines
monitor_memdump:
MemDump
	pha
	txa
	pha
	tya
	pha
	tay
		;jsr Monitor
		tsx
	  
		;jsr Monitor
		
		lda SPpage+$04,x
		sta t_RetAddrL
		;jsr Monitor
		lda SPpage+$05,x
		sta t_RetAddrH
		

		ldy #1
		lda (t_RetAddr),Y
		sta t_MemdumpL
		;jsr Monitor

		iny
		lda (t_RetAddr),Y
		sta t_MemdumpH
		;jsr Monitor


		iny
		lda (t_RetAddr),Y
		
		tax  
		jsr MemDumpDirectB

		tsx
		inc SPpage+$04,x
		inc SPpage+$04,x
		inc SPpage+$04,x
		
		
		lda SPpage+$04,x
		cmp #3
		bcs MemDump_NoIncSpH
		inc SPpage+$05,x
MemDump_NoIncSpH
	pla
	tay
	pla
	tax
	pla

	rts

MemDumpDirect
	ldy #8
MemDumpDirectB
	lda t_MemdumpH
	sta t_MemdumpBH
	;lda t_RetAddrH
	jsr printhex
	lda t_MemdumpL
	sta t_MemdumpBL
	;lda t_RetAddrL
	jsr printhex

	lda #":"
	jsr PrintCharA
	jsr NewLineA

	
	ldy #0
MemDump_Again
	;jsr Monitor

	tya
	pha
MemDump_AgainHex
		lda (t_MemdumpL),y

		jsr printhex
		lda #" "
		jsr PrintCharA
		iny
		tya
		and #%00000111
		bne MemDump_AgainHex
	pla
	tay
MemDump_AgainChar
	lda (t_MemdumpBL),y
	cmp #32
	Bcc MemDump_BadChar
	cmp #128
	Bcs MemDump_BadChar
MemDump_AgainCharRet
	
	jsr PrintCharA

	iny
	tya
	and #%00000111
	bne MemDump_AgainChar
	jsr NewLineA
MemDump_CarryOn
	
	dex
	bne MemDump_Again
		
	rts
MemDump_BadChar
	lda #"."
	jmp MemDump_AgainCharRet
	
		
		
Monitor:
	php
	pha
		pushpair z_bc
		tya 
		pha 
		txa 
		pha 
		
		lda #"a"
		jsr printmonitorchar
		tsx
		lda SPpage+$05,x			;Show Accumulator
		jsr printmonitorhex

		lda #"x"
		jsr printmonitorchar
		pla
		pha
		jsr printmonitorhex

		lda #"y"
		jsr printmonitorchar
		tya
		jsr printmonitorhex


		lda #"s"
		jsr printmonitorchar

		tsx
		txa
		clc
		adc #8
		jsr printmonitorhex			;Calculate Stack pointer before call

		lda #"f"
		jsr printmonitorchar
		tsx
		lda SPpage+$06,x
		jsr printmonitorhex
		
		lda #"p";Program Counter
		jsr printmonitorchar
		lda SPpage+$08,x
		jsr printhex
		lda SPpage+$07,x
		jsr printhex
		
		Jsr NewLineA

		
		pla
		tax
		pla
		tay
		pullpair z_bc
		pla     ;Pop A

	plp     ;Pop F
		
	rts
printmonitorchar
	jsr PrintCharA
	lda #":"
	jmp PrintCharA
printmonitorhex
	jsr printhex
	lda #" "
	jmp PrintCharA
   



AddDE_BC:			;Add DE to HL
	clc
	lda z_c
	adc z_e
	sta z_e
	lda z_b
	
	adc z_d
	sta z_d
	rts
	
AddHL_BC:			;Add BC to HL
	clc
	lda z_c
	adc z_l
	sta z_l
	lda z_b
	adc z_h
	sta z_h
	rts