

ramarea equ $E800	;Define some space for program vars
					;First 16 bytes reserved for core.
					
z_Regs equ $20		;Used for fake Z80 register pairs


	org $200-10		;10 byte header
	db $80,$08		;Fixed bytes
	db $02,$00		;Load address (Big endian)
	db $BE,$0A		;Length (Big Endian)
	db $42,$53,$39,$33
	
ProgramStart:

;ScreenInit	-	SUZY chip needs low byte setting first 
					;OR IT WILL WIPE THE HIGH BYTE!
	
	;Set screen ram pointer to $C000
	stz $FD94		;DISPADR	Display Address L (Visible)
	lda #$C0	
	sta $FD95		;DISPADR	Display Address H (Visible)
	
	
;Do the palette	
	ifdef UsePalette 
		ldx #0
		ldy #0
		loadpair z_hl,Palette
		stz $2121		;CGADD - Colour selection  
PaletteAgain:
		 ;gggrrrrr 
		lda (z_hl),y
		sta $FDB0,x		;CGDATA - Colour data register
		 ;?bbbbbgg 
		iny
		lda (z_hl),y
		sta $FDA0,x		;CGDATA
		iny
		inx
		cpx #16
		bne PaletteAgain
	
	else	;Minimal 4 color palette (Black Magenta Cyan White)

		stz $FDA0		;Palette Color 0 ----GGGG (Black)
		stz $FDB0		;Palette Color 0 BBBBRRRR (Black)
		
		stz $FDA1		;Palette Color 1 ----GGGG (Magenta)
		lda #%11111111	;Palette Color 1 BBBBRRRR (Magenta)
		sta $FDB1
		sta $FDB3		;Palette Color 3 BBBBRRRR (White)
		
		sta $FDA2		;Palette Color 2 ----GGGG (Cyan)
		sta $FDA3		;Palette Color 3 ----GGGG (White)
		
		lda #%11110000	
		sta $FDB2		;Palette Color 2 BBBBRRRR (Cyan)
	endif	
		
		
	jsr ClearRam	;Clear first 256 bytes of ram, and CLS
	
	
	