

		
NewLine:
	lda #0		
	sta z_d			;Cursor X=0

	inc z_e			;Cursor Y++

	lda z_e
	cmp #16			;At bottom of screen?
	bcs cls			; no? return, else cls!
	rts

cls:
	lda z_h
	pha
	lda z_l
	pha
	lda z_b
	pha
	lda z_c
	pha
		lda #0
		sta z_d			;x,y
		sta z_e
		sta z_l			;char,inc
		lda #32
		sta z_h

		lda #26		;width,height
		sta z_b
		lda #17
		sta z_c

		jsr fillarea	;Clear the screen
	pla
	sta	z_c
	pla
	sta z_b
	
	pla
	sta	z_l
	pla
	sta z_h
	rts

	
slowdown:	;this exists for systems that run too fast
	nop
	nop
	nop
	nop
	nop
	nop
	rts
	
	
PrintNumber:		;Print Digit 0-9
	clc
	adc #48			;ascii 0

PrintChar:			;Print char A at loc D,E
	cmp #0
	bne Notprintchar0
	inc z_d
	rts
Notprintchar0:	
	tax
	pha
	lda z_b
	pha
	lda z_c
	pha	
	lda z_h
	pha
	lda z_l
	pha
		txa
		sec
		sbc #32			;no char below 32
		
		cmp #64		
		bcc notlowercase ;Lowercase?
		sec			
		sbc #32			;Convert to upper!
notlowercase:		

;Calculate Font source
		asl			;*2
		sta z_l		
		lda #0
		sta z_h
		
		lda z_l
		asl			;*4
		rol z_h
		asl			;*8
		rol z_h
		asl			;*16
		rol z_h
		
		adc z_l		;+*2 = *18 bytes per char
		bcc PrintcharH
		inc z_h
		clc
PrintcharH
		adc #<Bitmapfont
		sta z_l
		lda z_h
		adc #>Bitmapfont
		sta z_h
												
;Calculate VRAM Dest
		lda z_d			;Xpos
		sta z_c
		asl	
		clc
		adc z_c			;Xpos *3
		sta z_c
		
		lda #$C0		;ScreenBase=$C000
		sta z_b
		
		ldx z_e
		beq PrintChary0
PrintCharyMult:
		lda #$E0		;Ypos*$1E0
		adc z_c
		sta z_c
		
		lda z_b
		adc #1
		sta z_b
		
		dex
		bne PrintCharyMult
PrintChary0:

;Transfer bitmap
		ldx #6			;6 lines
PrintCharByteY:
		ldy #3-1		;3 bytes per line
PrintCharByteX:			
		lda (z_hl),y
		sta (z_bc),y
		dey 
		bpl PrintCharByteX
		clc
		lda #$50		;Move Down 1 Line ($50 Bytes)
		adc z_c
		sta z_c
		bcc PrintCharBok
		inc z_b
		clc	
PrintCharBok:		
		lda #3
		adc z_l
		sta z_l
		bcc PrintCharHok
		inc z_h
PrintCharHok:
		dex 
		bne PrintCharByteY
	pla
	sta	z_l
	pla
	sta z_h
	pla
	sta	z_c
	pla
	sta z_b
	pla
	inc z_d
	rts

	
ReadJoystick:	;%12IORLDU
	lda #$FF
	sta z_as			;Buildup byte	
	
	eor $FCB0		;JOYSTICK	Read Joystick and Switches	UDLR12IO
			;(I= Inside Fire, O=Outside Fire, 1=Option 1, 2=Option 2)
			;FCB1 = Pause button on bit 0
			
	jsr SwapNibbles		;swap %UDLR12IO to %12IOUDLR
	tay					;Back up %12IO---- for later
		ldx #4
JoystickNextBitsB:		;shift %----UDLR into %----RLDU
		ror
		rol z_as		;Flip the order of the bits
		dex
		bne JoystickNextBitsB
	tya					;Get back backup 12IOUDLR
	ora #%00001111		;keep Fires %12IO----
	and z_as			;AND in     %----RLDU
	rts
	
		
SwapNibbles:	;$AB -> $BA
	asl 				;(shift left - bottom bit zero)
	adc #$80 			;(pop top bit off - add carry)
	rol 				;(shift carry in)
		;2 bits moved
	asl 				;(shift left - bottom bit zero)
	adc #$80 			;(pop top bit off - add carry)
	rol 				;(shift carry in)
	rts	;4 bits moved
	

Bitmapfont:		;6*6 pixels = 18 bytes per char
	ds 18		;Space
	DB $00,$03,$00,$00,$02,$00,$00,$02,$00,$00,$00,$00,$00,$02,$00,$00,$00,$00     ;  0
	DB $02,$33,$20,$00,$22,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;  1
	DB $00,$33,$00,$02,$22,$20,$00,$22,$00,$00,$11,$00,$00,$00,$00,$00,$00,$00     ;  2
	DB $00,$33,$23,$02,$02,$00,$00,$22,$20,$01,$22,$10,$00,$01,$00,$00,$00,$00     ;  3
	DB $32,$00,$20,$22,$02,$00,$00,$00,$00,$01,$00,$12,$10,$00,$11,$00,$00,$00     ;  4
	DB $00,$33,$00,$00,$22,$00,$02,$20,$02,$20,$02,$10,$01,$10,$01,$00,$00,$00     ;  5
	DB $00,$03,$20,$00,$20,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ;  6
	DB $00,$03,$00,$00,$20,$00,$00,$20,$00,$00,$02,$00,$00,$01,$00,$00,$00,$00     ;  7
	DB $00,$03,$00,$00,$02,$20,$00,$02,$20,$00,$02,$00,$00,$01,$00,$00,$00,$00     ;  8
	DB $03,$02,$00,$00,$22,$02,$00,$02,$20,$00,$20,$02,$01,$00,$00,$00,$00,$00     ;  9
	DB $00,$03,$00,$00,$02,$00,$02,$22,$22,$00,$02,$00,$00,$00,$00,$00,$00,$00     ; 10
	DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$02,$00,$00,$01,$00,$00,$10,$00     ; 11
	DB $00,$00,$00,$00,$00,$00,$02,$22,$22,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 12
	DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$02,$00,$00,$01,$00,$00,$00,$00     ; 13
	DB $00,$00,$20,$00,$02,$00,$00,$00,$00,$01,$00,$00,$10,$00,$00,$00,$00,$00     ; 14
	DB $03,$33,$30,$12,$20,$22,$12,$02,$22,$11,$00,$11,$01,$11,$10,$00,$00,$00     ; 15
	DB $00,$03,$00,$00,$02,$00,$00,$02,$00,$00,$02,$00,$00,$01,$00,$00,$00,$00     ; 16
	DB $03,$33,$33,$00,$00,$22,$00,$22,$20,$01,$00,$00,$00,$11,$10,$00,$00,$00     ; 17
	DB $03,$33,$33,$00,$00,$22,$00,$02,$20,$00,$00,$12,$00,$11,$10,$00,$00,$00     ; 18
	DB $00,$33,$30,$02,$20,$20,$02,$22,$20,$00,$02,$10,$00,$01,$00,$00,$00,$00     ; 19
	DB $02,$33,$23,$02,$20,$00,$02,$22,$20,$00,$00,$12,$00,$11,$11,$00,$00,$00     ; 20
	DB $00,$03,$23,$02,$20,$00,$02,$22,$20,$01,$20,$12,$00,$11,$10,$00,$00,$00     ; 21
	DB $02,$33,$23,$00,$00,$22,$00,$02,$20,$00,$02,$00,$00,$20,$00,$00,$00,$00     ; 22
	DB $00,$32,$20,$02,$20,$22,$00,$22,$20,$01,$20,$12,$00,$11,$10,$00,$00,$00     ; 23
	DB $00,$32,$20,$02,$20,$22,$00,$02,$22,$01,$00,$12,$00,$11,$10,$00,$00,$00     ; 24
	DB $00,$00,$00,$00,$03,$00,$00,$02,$00,$00,$02,$00,$00,$01,$00,$00,$00,$00     ; 25
	DB $00,$00,$00,$00,$03,$00,$00,$02,$00,$00,$02,$00,$00,$01,$00,$00,$10,$00     ; 26
	DB $00,$03,$20,$00,$22,$00,$02,$20,$00,$00,$02,$10,$00,$01,$10,$00,$00,$00     ; 27
	DB $00,$00,$00,$02,$33,$23,$00,$00,$00,$01,$22,$12,$00,$00,$00,$00,$00,$00     ; 28
	DB $02,$30,$00,$00,$22,$00,$00,$02,$20,$01,$20,$00,$01,$10,$00,$00,$00,$00     ; 29
	DB $02,$30,$23,$00,$00,$22,$00,$02,$20,$00,$01,$00,$00,$01,$00,$00,$00,$00     ; 30
	DB $32,$02,$23,$20,$20,$22,$20,$20,$22,$21,$20,$00,$01,$11,$10,$00,$00,$00     ; 31
	DB $00,$33,$30,$02,$20,$22,$01,$20,$22,$01,$22,$12,$01,$10,$11,$00,$00,$00     ; 32
	DB $02,$32,$23,$02,$20,$22,$01,$22,$20,$01,$20,$12,$01,$11,$10,$00,$00,$00     ; 33
	DB $02,$33,$20,$12,$00,$00,$12,$00,$00,$01,$22,$10,$00,$11,$00,$00,$00,$00     ; 34
	DB $02,$32,$20,$02,$20,$22,$01,$20,$22,$01,$20,$10,$01,$11,$00,$00,$00,$00     ; 35
	DB $02,$33,$20,$02,$20,$00,$01,$22,$00,$01,$20,$00,$01,$11,$10,$00,$00,$00     ; 36
	DB $02,$33,$20,$02,$20,$00,$01,$22,$00,$01,$20,$00,$01,$10,$00,$00,$00,$00     ; 37
	DB $02,$32,$23,$12,$00,$00,$12,$00,$22,$01,$20,$12,$00,$11,$10,$00,$00,$00     ; 38
	DB $02,$30,$23,$01,$20,$22,$01,$22,$22,$01,$20,$12,$00,$10,$10,$00,$00,$00     ; 39
	DB $00,$03,$00,$00,$02,$00,$00,$02,$00,$00,$02,$00,$00,$01,$00,$00,$00,$00     ; 40
	DB $00,$03,$20,$00,$02,$20,$00,$02,$20,$11,$22,$10,$01,$11,$00,$00,$00,$00     ; 41
	DB $02,$30,$23,$01,$22,$20,$01,$22,$00,$01,$20,$12,$01,$10,$11,$00,$00,$00     ; 42
	DB $02,$30,$00,$01,$20,$00,$01,$20,$00,$01,$22,$10,$01,$11,$10,$00,$00,$00     ; 43
	DB $02,$33,$20,$22,$22,$22,$10,$20,$22,$11,$00,$12,$01,$00,$10,$00,$00,$00     ; 44
	DB $32,$30,$23,$12,$20,$22,$12,$02,$22,$11,$00,$12,$11,$00,$10,$00,$00,$00     ; 45
	DB $02,$33,$20,$12,$00,$22,$12,$00,$22,$01,$22,$11,$01,$11,$10,$00,$00,$00     ; 46
	DB $03,$33,$00,$02,$20,$20,$01,$22,$20,$01,$20,$00,$01,$10,$00,$00,$00,$00     ; 47
	DB $02,$33,$20,$12,$00,$22,$12,$00,$22,$01,$10,$10,$00,$11,$01,$00,$00,$00     ; 48
	DB $02,$33,$33,$01,$20,$22,$01,$22,$20,$01,$20,$12,$01,$10,$11,$00,$00,$00     ; 49
	DB $00,$32,$23,$02,$20,$00,$00,$22,$20,$00,$00,$12,$01,$11,$10,$00,$00,$00     ; 50
	DB $02,$33,$23,$00,$02,$00,$00,$02,$00,$00,$02,$00,$00,$01,$00,$00,$00,$00     ; 51
	DB $02,$30,$23,$02,$20,$22,$02,$20,$22,$01,$20,$12,$00,$11,$10,$00,$00,$00     ; 52
	DB $02,$30,$23,$01,$20,$22,$01,$20,$22,$00,$22,$10,$00,$01,$00,$00,$00,$00     ; 53
	DB $32,$00,$23,$12,$00,$22,$12,$10,$22,$12,$11,$21,$01,$00,$10,$00,$00,$00     ; 54
	DB $02,$30,$22,$00,$22,$20,$02,$22,$00,$11,$02,$12,$01,$00,$10,$00,$00,$00     ; 55
	DB $02,$30,$23,$02,$20,$22,$00,$22,$20,$00,$02,$20,$00,$01,$10,$00,$00,$00     ; 56
	DB $33,$33,$20,$00,$02,$20,$00,$22,$00,$01,$22,$12,$01,$11,$10,$00,$00,$00     ; 57
	DB $00,$30,$00,$00,$20,$00,$00,$20,$00,$00,$20,$00,$00,$01,$10,$00,$00,$00     ; 58
	DB $02,$00,$00,$00,$20,$00,$00,$00,$00,$00,$00,$10,$00,$00,$01,$00,$00,$00     ; 59
	DB $00,$03,$20,$00,$02,$20,$00,$02,$20,$00,$02,$10,$00,$11,$00,$00,$00,$00     ; 60
	DB $00,$33,$20,$02,$22,$22,$00,$02,$00,$00,$02,$00,$00,$01,$00,$00,$00,$00     ; 61
	DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$11,$11,$11,$11,$11,$11     ; 62
	DB $00,$03,$00,$00,$02,$20,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00     ; 63

	
	;incbin "\ResAll\ChibiAdventure\Font6x6.raw"	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		
	
	org $fffe
	dw ProgramStart			;Reset Vector 
	