;buildCPC equ 1
;macro include filen
;	read filen
;endm



Answer equ ramarea+16
Guess equ ramarea+17		;2 bytes (combined into 1 byte value)
Tries equ ramarea+19

	
	include "header.asm"
	
	
AnotherGo:	
	lda #0
	sta tries
	
	lda #>strStart				;Show title message
	sta z_h
	lda #<strStart
	sta z_l
	
	
	jsr PrintSeq

	jsr WaitForFire		

	jsr DoRandom
	sta Answer				;Decide what the answer is 

AnotherGuess:
	jsr WaitForRelease		;Wait for joystick release

	lda #>strGuess
	sta z_h
	lda #<strGuess
	sta z_l
	jsr PrintSeq			;Show the guess message
GuessLoop:
	lda z_d
	pha
	lda z_e
	pha
		jsr ReadJoystick		;Get keypresses into A
		sta z_c
		
		lda Guess+1
		jsr JoyAxis		;Up/Down (+-16)
		sta z_h
		sta Guess+1

		lda Guess
		jsr JoyAxis		;Left/Right (+-1)
		sta z_l
		sta Guess

		lda z_l			;LR=+-16
		asl
		asl
		asl
		asl
		clc
		adc z_h			;UD=+-1
		
		sta z_b			;Combine H and L ionto B

	pla 
	sta z_e
	tax
	pla
	sta z_d
	pha
	txa
	pha
		lda z_b
		jsr ShowDecimal
	pla 
	sta z_e
	pla
	sta z_d

	jsr Pause50
	
	lda z_c
	and #%00000001
	beq TestGuess	;Test Fire

	jmp GuessLoop
TestGuess:
	
	inc tries			;Another try used 

	lda Answer
	cmp z_b
	beq TestCorrect	;Is answer Correct?
	php
		lda #>strLow
		sta z_h
		lda #<strLow
		sta z_l
	plp
	bcs AnswerLow		;Is answer too Low
	lda #>strHigh
	sta z_h
	lda #<strHigh
	sta z_l

AnswerLow:
	jsr PrintSeq
	jmp AnotherGuess

TestCorrect:
	jsr NewLine
	lda #>strCorrect
	sta z_h
	lda #<strCorrect
	sta z_l
	
	jsr PrintSeq
	
	lda tries
	jsr ShowDecimal

	jsr PrintSeq

	jsr WaitForFire
	jsr Cls
	jmp AnotherGo

strStart:	db 'Guess My Number!',254
		db 'Press Fire to start',254,255	;String to show
strGuess:	db 'Your Guess >',255	;String to show
strCorrect: 	db 'Correct! You took ',255,' Tries!',255
strLow:		db 253,'Too Low!',254,255
strHigh:	db 253,'Too High!',254,255

	include "core.asm"	
	include "footer.asm"
 