

VM_RamBase equ ramarea+$100
VM_StackTop equ VM_RamBase+$100


;Controls:
;Fire: Cause Trap
;UP: Step 1 Tick
;Right: run emulator

;vm_useVMEM equ 1			;Enable Virtual address remapper

	include "\SrcALL\ChibiVm_InstSet.asm"

	;Basic macros for ASM tasks
	include "\SrcAll\BasicMacros.asm"

;z_Regs 		equ $70
SPpage equ $0100



	include "header.asm"
	
	jsr ChibiVM_Init
	
;ShowVMMonitor equ 1
		
	
InfLoop:	

	ifdef ShowVMMonitor
		lda #0
		sta z_CursorX
		lda #12
		sta z_CursorY

	
;ZeroPage
		jsr MemDump			;Show Some Ram to screen
		word VM_RamBase     ;Address to show
		byte $3         	;Lines
	
	
;Stack
		jsr MemDump			;Show Some Ram to screen
		word VM_StackTop-16 ;Address to show
		byte $2        		;Lines
	
;Program
		lda VM_RamBase+VM_rPC
		sta t_MemdumpL
		lda VM_RamBase+VM_rPC+1
		sta t_MemdumpH
		ldx #1
		jsr MemDumpDirect
	endif
	
	jsr VM_Tick

	;jsr WaitForFire
	
	jmp InfLoop


;	org $1000
	
;FU records stage being run.
;OK = no problems
;NG = No Good - Problem occurred at stage marked by FU register
	
TestProgram:

	Macro AdvCall,p1
		dbb SYSi,syscallAdventure
		db \p1
	endm
	
	
;Zero page entries for variables	
Answer equ 16
Guess equ 17		;2 bytes (combined into 1 byte value)
Tries equ 19	
		
AnotherGo:
	dbbw mov16x,R6_imm16,strStart	;Show title message
	AdvCall aPrintSeq 
	
	AdvCall aWaitForFire 
	
	AdvCall aDoRandom
	dbb stoz,Answer					;Decide what the answer is 
	
AnotherGuess:	
	AdvCall aWaitForRelease			;Wait for joystick release
	
	dbbw mov16x,R6_imm16,strGuess
	AdvCall aPrintSeq 				;Show the guess message
	
GuessLoop:	
	db ph4b
		AdvCall aReadJoystick		;Get keypresses into A
		dbb stoz,R2
		
		dbb movz,Guess+1
		AdvCall aJoyAxis			;Up/Down (+-16)
		dbb stoz,R7
		dbb stoz,Guess+1

		dbb movz,Guess
		Advcall AJoyAxis			;Left/Right (+-1)
		dbb stoz,R6
		dbb stoz,Guess
		
		dbb movz,R6
		db ASLb						;LR=+-16
		db ASLb
		db ASLb
		db ASLb
		dbb addz,R7					;UD=+-1
		
		dbb stoz,R3					;Combine H and L onto B

	db pl4b
	db ph4b
		Advcall aShowDecimal
	db pl4b

	Advcall aPause50
	
	dbbb TSTx,R2_imm8,%00000001
	dbw beqj,TestGuess				;Test Fire

	dbw braj,GuessLoop
	
TestGuess:	
	dbb incz,tries					;Another try used 

	dbbb cmpx,ZeroPg_r3,Answer
	dbw beqj,TestCorrect			;Is answer Correct?
	
	;dbb SYSi,syscallMonitor

	dbbw mov16x,r6_imm16,strLow	
	dbw bccj,AnswerLow				;Is answer too Low
	dbbw mov16x,r6_imm16,strHigh
AnswerLow:
	AdvCall aPrintSeq
	dbw braj,AnotherGuess

TestCorrect:
	AdvCall aNewLine

	dbbw mov16x,r6_imm16,strCorrect	;Problem solved!
	AdvCall aPrintSeq
	dbw movz,tries
	AdvCall aShowDecimal

	AdvCall aPrintSeq

	AdvCall aWaitForFire
	AdvCall aCls
	dbw braj,AnotherGo				;Repeat for next game
		
	db HLTb
	
	

strStart:	db 'Guess My Number!',254
		db 'Press Fire to start',254,255	;String to show
strGuess:	db 'Your Guess >',255	;String to show
strCorrect: 	db 'Correct! You took ',255,' Tries!',255
strLow:		db 253,'Too Low!',254,255
strHigh:	db 253,'Too High!',254,255



vm_Traps:
	dw TestProgram
	
vm_AddressRemapTable:

	include "\SrcALL\ChibiVm_CPU.asm"
	include "\Sources\ChibiVM\ChibiVM_AdventureEngine.asm"
	include "\Sources\ChibiVM\ChibiVM_Host.asm"
	
	include "monitor.asm"		
	include "core.asm"	
	include "footer.asm"
 