
A52_FourColor equ 1

VM_RamBase equ ramarea+$100
VM_StackTop equ VM_RamBase+$100

HspriteCount equ VM_RamBase+64
HspriteLimit equ VM_RamBase+65
SpriteArrayRam equ VM_RamBase+$300


	Macro NSCall,p1
		dbb SYSi,syscallNS
		db \p1
	endm
	
VscreenMinX equ 64		;Top left of visible screen in logical co-ordinates
VscreenMinY equ 80

VscreenWid equ 128		;Visible Screen Size in logical units
VscreenHei equ 96
	
	ifdef BuildPCE
SpritePatternSize equ 32*4
	endif
	
	ifdef BuildC64
SpritePatternSize equ 64	;24x21 = 63 bytes in 2 color mode
	endif

	ifndef SpritePatternSize
SpritePatternSize equ 32
	endif

BBC_NativeSprite_PatternOffset equ -1
A52_NativeSprite_PatternOffset equ -1
AP2_NativeSprite_PatternOffset equ -1
LNX_NativeSprite_PatternOffset equ -1

NES_SpritePatternVram equ $1000
	;ifdef BuildNES
; VDP_L equ z_Regs+18			;Position of next Tile in buffer L
; VDP_H equ z_Regs+19			;Position of next Tile in buffer H
; VDP_Update equ z_Regs+20	;VDP Update Flag
; VDPBuffer equ $300				;$400 byte Tilemap Buffer
; SpriteBuffer equ $200	;$100 byte Sprite data (64 sprites)
NES_UseTileBuffer equ 1
NES_UseSpriteBuffer equ 1
NES_Sprite8x16 equ 1
	;endif
	
C64_SpritePatternCount equ 32
C64_SpritePatternVram equ $5000	;Scrbase+$1000
C64_Multicolor1 equ 1			;White
C64_Multicolor2 equ 2			;Red

SNS_SpriteSize0 equ 1		;8x8    16x16
;SNS_SpriteSize1 equ 1		;8x8    32x32
;SNS_SpriteSize2 equ 1		;8x8    64x64
;SNS_SpriteSize3 equ 1		;16x16  32x32
;SNS_SpriteSize4 equ 1		;16x16  64x64
;SNS_SpriteSize5 equ 1		;32x32  64x64
;SNS_SpriteSize6 equ 1		;16x32  32x64 (undocumented)
;SNS_SpriteSize7 equ 1		;16x32	32x32 (undocumented)
SNS_SpriteSize equ 0	;0,1,2,3,4,5,6,7

SnesSpriteBuffer equ $0A00 	;Sprite buffer at $0A00+ ($220 bytes)
SNS_SpritePatternVram equ $4000

PCE_SpritePatternCount equ 32
PCE_SpritePatternVram equ $2000


;vm_useVMEM equ 1			;Enable Virtual address remapper

	include "\SrcALL\ChibiVm_InstSet.asm"

	;Basic macros for ASM tasks
	include "\SrcAll\BasicMacros.asm"

;z_Regs 		equ $70
SPpage equ $0100



	include "header.asm"
	
	loadpair z_hl,SpriteArray
	loadpair z_de,SpriteArrayRam
	loadpair z_bc,32
	jsr DoLdir
	
	
	jsr ChibiVM_Init
	
;ShowVMMonitor equ 1
		
	; loadpair z_hl,SpritePatterns
	; jsr NativeSpr_Init
	
	; loadpair z_hl,SpriteArray
	; jsr NativeSpr_DrawArray
	
	; jsr nativespr_hidearray
	
	; jmp *
	
InfLoop:	

	jsr VM_Tick

	;jsr WaitForFire

	


	ifdef ShowVMMonitor
		lda #0
		sta z_CursorX
		lda #12
		sta z_CursorY

	
;ZeroPage
		jsr MemDump			;Show Some Ram to screen
		word VM_RamBase     ;Address to show
		byte $3         	;Lines
	
	
;Stack
		jsr MemDump			;Show Some Ram to screen
		word VM_StackTop-16 ;Address to show
		byte $2        		;Lines
	
;Program
		lda VM_RamBase+VM_rPC
		sta t_MemdumpL
		lda VM_RamBase+VM_rPC+1
		sta t_MemdumpH
		ldx #1
		jsr MemDumpDirect
	endif
	
	

	;jsr VM_Tick

	;jsr WaitForFire
	
	jmp InfLoop
	

;	org $1000
	
;FU records stage being run.
;OK = no problems
;NG = No Good - Problem occurred at stage marked by FU register
	

	Macro AdvCall,p1
		dbb SYSi,syscallAdventure
		db \p1
	endm
	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
		
	
		
ballpos equ			ramarea+16
ballmove equ		ramarea+18
PlayerPaddle equ	ramarea+20
CpuPaddle equ		ramarea+22
PlayerScore equ		ramarea+24
CpuScore equ		ramarea+25
GameTick equ		ramarea+26
GameSpeed equ		ramarea+27		
GameAI equ			ramarea+28
SoundByte equ		ramarea+29 

	;org $800
TestProgram:
	dbbw mov16x,r6_imm16,SpritePatterns		;Sprite patterns
	dbbw mov16x,r2_imm16,4*SpritePatternSize	;ByteCount
	NSCall nsInit 
	
	
	
	dbbw mov16x,r6_imm16,SpriteArrayRam	;Ram
	NSCall nsDrawArray+regRR 			;SpriteArray
	
	
	
newgame:
	NSCall nsHideAll+regNO
	
	
	;dbbw mov16x,r6_imm16,SpriteArrayRam	;Ram
	;NSCall nsDrawArray+regRR 			;SpriteArray

	advcall acls
	
	dbbw mov16x,r6_imm16,$0000		;speed - ai
titlescreen:
	advcall apause50
	dbbw mov16x,r4_imm16,$0000		;cursorpos
	
	db ph6b
		dbbw mov16x,r6_imm16,strstart
		advcall aprintseq
		
		dbbw mov16x,r6_imm16,strspeed	;Show 'Speed'
		advcall aprintseq
	db pl6b
	dbbb movx,r0_zeropg,r7	
	advcall ashowdecimal				;Show Speed Value
	
	db ph6b
		dbbw mov16x,r6_imm16,strai		;Show 'AI'
		advcall aprintseq
	db pl6b
	dbb movx,r0_r6
	advcall ashowdecimal				;Show AI Value 

	advcall areadjoystick				;%---FRLDU
	dbb movx,r2_r0

	dbbw mov16x,r4_imm16,$0004			;Min=0 Max=3

	dbb movx,r0_r6
	advcall ajoyaxis					;Up/Down
	advcall arangelimit
	dbb movx,r6_r0

	dbbb movx,r0_zeropg,r7
	advcall ajoyaxis					;Left/Right
	advcall arangelimit
	dbbb movx,zeropg_r0,r7

	dbbb tstx,r2_imm8,1					;Fire?
	dbb bnei,titlescreen-lbl35419		;No? Then Repeat!
lbl35419



	dbbb movx,r0_zeropg,r7
	dbw bsrj,readmask					;Get Game Speed
	dbbw stox,r0_addr16,gamespeed

	dbb movx,r0_r6
	dbw bsrj,readmask					;Get CPU AI
	dbbw stox,r0_addr16,gameai

	dbw bsrj,rezeroball					;Center the ball

 	dbbw sto16x,r4_addr16,ballpos

	dbbww mov16x,addr16_imm16,ballmove,$ffff	;ball pos -1 = facing player

	dbbwb movx,addr16_imm8,playerpaddle,6*4		;ypos
	dbbwb movx,addr16_imm8,cpupaddle,6*4

	dbbw clrx,addr16_r0,cpuscore
	dbbw clrx,addr16_r0,playerscore				;Zero Score

	dbbwb movx,addr16_imm8,playerpaddle+1,0*4	;Xpos
	dbbwb movx,addr16_imm8,cpupaddle+1,19*4

	advcall acls
	dbbw mov16x,r6_imm16,strwall
	advcall aprintseq							;Draw Top/Bottom wall
	
	dbw bsrj,ShowScores							;ShowScores

gameloop:

	dbbw mov16x,r4_addr16,ballpos
	db ph4b
			
		dbbbb addx,zeropg_imm8,r4,VscreenMinY		;Offset ballpos
		dbbbb addx,zeropg_imm8,r5,VscreenMinX		; for sprite co-ords
		dbbw sto16x,r4_addr16,SpriteArrayRam+9	
		
		dbw bsrj,getplayerpaddlede
		dbbbb addx,zeropg_imm8,r4,VscreenMinY		;Offset player paddle
		dbbbb addx,zeropg_imm8,r5,VscreenMinX
		dbbw sto16x,r4_addr16,SpriteArrayRam+1
			
		dbw bsrj,getcpupaddlede						
		dbbbb addx,zeropg_imm8,r4,VscreenMinY		;Offset CPU paddle
		dbbbb addx,zeropg_imm8,r5,VscreenMinX
		dbbw sto16x,r4_addr16,SpriteArrayRam+5
			
		dbbw mov16x,r6_imm16,SpriteArrayRam			
		NSCall nsDrawArray+regRR 			;Draw the Native SpriteArray


		dbbw movx,r0_addr16,soundbyte
		advcall achibisound+regRR			;Play sound byte
		dbbw clrx,addr16_r0,soundbyte		;Clear the sound byte
		
		
	db pl4b

	
	dbbw movx,r0_addr16,gametick
	db incb									;Increment the game tick
	dbbw stox,r0_addr16,gametick

	dbbw andx,r0_addr16,gamespeed	;See if we move the ball this tick

	dbb bnei,noballmove-lbl65191
lbl65191
	dbbw mov16x,r2_addr16,ballmove		;Get the Ball move amount
	dbw bsrj,moveball					;Move the ball
noballmove:

		dbw bsrj,getplayerpaddlede			;Get Player pos

	advcall areadjoystick				;Get Joystick directions
	dbb movx,r2_r0
	dbw bsrj,processpaddle				;Move player
 	dbbw sto16x,r6_addr16,playerpaddle
	
	dbw bsrj,getcpupaddlede				;Get CPU pos

	dbbb movx,r2_imm8,%11111111			; No move 
	
	dbbw movx,r0_addr16,gametick
	dbbw andx,r0_addr16,gameai			;See if CPU can move this tick
	dbb bnei,cpudecided-lbl61257		; Based on AI level
lbl61257

	dbbw movx,r0_addr16,ballpos
	dbb subi,1							;See how Ballpos compares to
	dbb cmpz,r4							; Paddle pos 
	dbb beqi,cpudecided-lbl43064
lbl43064

	dbb bcsi,cpuup-lbl27499
lbl27499

	dbbb movx,r2_imm8,%11111101			;Set Down on 'CPU joypad'
	dbb brai,cpudecided-lbl36249
lbl36249

cpuup:
	dbbb movx,r2_imm8,%11111110			;Set Up on 'CPU joypad

cpudecided:
	dbw bsrj,processpaddle				;Move CPU based on R2
	dbbw mov16x,addr16_r6,cpupaddle

	dbbw movx,r0_addr16,cpuscore
	dbbw orrx,r0_addr16,playerscore
	dbb cmpi,8							;Has anyone scored 8 yet?
	dbw bcsj,gameloop					
	

	dbbw mov16x,r6_imm16,strgameover
	dbbw mov16x,r4_imm16,$0608
	advcall aprintseq					;Show 'Game over'
	
	advcall awaitforfire
	dbw braj,newgame

	
getplayerpaddlede:
	dbbw mov16x,r4_addr16,playerpaddle		;Get Player pos
	db rtsb

getcpupaddlede:
	dbbw mov16x,r4_addr16,cpupaddle			;Getr CPU pos
	db rtsb

	
moveball:
	dbbwb movx,addr16_imm8,soundbyte,%10100000
	dbbw mov16x,r6_addr16,playerpaddle

	dbbbb cmpx,zeropg_imm8,r5,1*4-1			;Ball at far left?
	
	dbb bnei,noplayerpaddlehit-lbl50130
lbl50130

	dbw bsrj,paddletest						;CarrySet=Miss!
	dbb bcci,noplayerpaddlehit-lbl28645
lbl28645
	dbw bsrj,cpuscores						;Player Missed ball


noplayerpaddlehit:
	dbbw mov16x,r6_addr16,cpupaddle

	dbbbb cmpx,zeropg_imm8,r5,18*4+1		;Ball at far right?
	
	dbb bnei,nocpupaddlehit-lbl7460
lbl7460
	dbw bsrj,paddletest						;CarrySet=Miss!
	dbb bcci,nocpupaddlehit-lbl16183
lbl16183
	dbw bsrj,playerscores					;Cpu Missed ball

	
nocpupaddlehit:
	dbbb addx,zeropg_r3,r5				;update ball ypos
	dbb  addx,r4_r2						
	dbbb cmpx,r4_imm8,1*4				;hit top wall?
	dbb bnei,lbl5063-lbl23676
lbl23676
	dbw bsrj,flipy						;Flip the ball Y movement
lbl5063
	dbbb cmpx,r4_imm8,16*4				;hit bottom wall?
	dbb bnei,lbl16101-lbl21583
lbl21583
	dbw bsrj,flipy						;Flip the ball Y movement
lbl16101
 	dbbw sto16x,r4_addr16,ballpos		;Store Ball pos
 	dbbw sto16x,r2_addr16,ballmove		;Store Ball move
	db rtsb

paddletest:		;CarrySet=Miss!	  CarryClear=HitPaddle
	dbb movx,r0_r4
	dbb cmpz,r6							;< bottom of paddle
	dbb bcsi,paddlemiss-lbl22097		
lbl22097
	dbb subi,3*4
	dbb cmpz,r6							;> top of paddle
	dbb bcci,paddlemiss-lbl59932
lbl59932
										;Hit the paddle!
										
	dbw bsrj,flipx						;Flip the ball X movement

	dbbwb movx,addr16_imm8,soundbyte,%01000000	;Make a 'Hit' beep

	dbb orrz,r0							;Clear carry
	db rtsb

paddlemiss:
	dbbwb movx,addr16_imm8,soundbyte,%01110000	;Make a 'duh' sound
	dbbb movx,rf_imm8,3					;Set carry
	db rtsb

cpuscores:
	dbbw incx,addr16_r0,cpuscore		;Add one to CPU score
	dbw bsrj,ShowScores					;Show scores to screen
	
	dbw braj,rezeroball					;Center ball


playerscores:
	dbbw incx,addr16_r0,playerscore		;Add one to Player score
	dbw bsrj,ShowScores					;Show scores to screen
rezeroball:	
	dbbw mov16x,r4_imm16,$0a08*4		;Center ball (then xflip moves)


flipx:
	dbb negz,r3							;X=-X
	db rtsb

flipy:
	dbb negz,r2							;Y=-Y
	db rtsb
	

processpaddle:
	dbb mov16x,r6_r4

	dbbw mov16x,r4_imm16,$010e*4		;Min-Max range for paddle
	dbb movx,r0_r6
	advcall ajoyaxis					;Process Up/Down
	advcall arangelimit					;Check we're still onscreen
	dbb movx,r6_r0						
	db rtsb

readmask:
	dbbbb movx,zeropg_imm8,r5,0
	dbb movx,r4_r0
	dbbw add16x,r4_imm16,masks		;Add R0 to 'Masks'
	dbb movx,r0_atr4				;Get R0 from resulting mask
	db rtsb

	
ShowScores:
	db ph4b
		dbbw mov16x,r4_imm16,$0011
		dbbw movx,r0_addr16,playerscore	
		advcall ashowdecimal				;Show Player score

		dbbw mov16x,r4_imm16,$1111
		dbbw movx,r0_addr16,cpuscore
		advcall ashowdecimal				;Show CPU Score
	db pl4b
	db rtsb	
	
;Speed masks for ball and AI	
Masks:	db %00000111,%00000011,%00000001,%00000000


strGameOver:db 'Game Over',255
strStart:	db 'Sprong - Sprite Pong!',253,255

strSpeed:	db 253,'Speed:',255
strAi:		db 253,'AI:',255

strWall:	 db $B3,'-',253,$F1	;253=Newline (Xpos=0) $F1= Ypos=17
			 db $B3,'-',255		;$B3=18 char H strip

			 

SpritePatterns:	
	ifdef BuildBBC
		incbin "\ResALL\Reikou\Sprong\BBC_Sprong.raw"
	endif
	ifdef BuildA52
		incbin "\ResALL\Reikou\Sprong\A52_Sprong.raw"
	endif
	ifdef BuildA80
		incbin "\ResALL\Reikou\Sprong\A52_Sprong.raw"
	endif
	ifdef BuildAP2
		incbin "\ResALL\Reikou\Sprong\AP2_Sprong.raw"
	endif
	ifdef BuildLNX
		incbin "\ResALL\Reikou\Sprong\LNX_Sprong.raw"
	endif
	
	
	ifdef BuildPCE
		incbin "\ResALL\Reikou\Sprong\PCE_Sprong.raw"
		
SpriteData_Bat2:	
SpriteData_Bat1:
		db 1,2		;W,H
		dw $0080	;Attribs
		dw $2000>>5,$2040>>5	;>>5 converts to correct
								;      tile offset for PCE
SpriteData_Ball:
		db 1,1		;W,H
		dw $0080	;Attribs
		dw $2080>>5
	endif
	
;Attribs YF	-YS	YS XF -	- XS  F	- -	- P	P P	P	
;	YF=Yflip XF=Xflip YS=Ysize (16/32/64) XS=Xsize (16/32)
;	F=Foreground (infront of tilemap) P=Palette (256+)
	
	
	ifdef BuildNES
		incbin "\ResALL\Reikou\Sprong\NES_Sprong.raw"
		
SpriteData_Bat2:	
SpriteData_Bat1:
		db 1,3		;W,H
		dw $0400,$0401,$0402	;%VHB---PP TTTTTTTT
								;Vflip  Hflip  Bg pri  Pal  Tile patt
								;the $04 is just to avoid $0000
SpriteData_Ball:
		db 1,1		;W,H
		dw $0403
	endif
	
	
	ifdef BuildSNS
		incbin "\ResALL\Reikou\Sprong\SNS_Sprong.raw"
		
SpriteData_Bat2:	
SpriteData_Bat1:
		db 1,3		;W,H
		db %00		;Size: %00=Normal (8x8) or %10=Large (16x16)
		dw $3000,$3001,$3002 ;$30=Layer Priority (%YXPPCCCT TTTTTTTT)
	
SpriteData_Ball:
		db 1,1		;W,H
		db %00		;Size: %00=Normal (8x8) or %10=Large (16x16)
		dw $3003	;$30=Layer Priority (%YXPPCCCT TTTTTTTT)
	endif
	
	
	
	ifdef BuildC64
		incbin "\ResALL\Reikou\Sprong\C64_Sprong.raw"
		
SpriteData_Bat2:	
		db 1,2			;W,H
		db %0000		;1=DoubleHeight 2=DoubleWidth
		dw $4007,$4107 	;Pattern / Color (+$10=4color mode)
SpriteData_Bat1:
		db 1,2			;W,H
		db %0000		;1=DoubleHeight 2=DoubleWidth
		dw $4005,$4105	;Pattern / Color (+$10=4color mode)
	
SpriteData_Ball:
		db 1,1			;W,H
		db %0000		;1=DoubleHeight 2=DoubleWidth
		dw $420A		;Pattern / Color (+$10=4color mode)
			
	endif
	

	
SpriteArray:
	db 3		;Count
	dw $7080,SpriteData_Bat1	;XXYY,Sprite
	dw $9080,SpriteData_Bat2	;XXYY,Sprite
	dw $8080,SpriteData_Ball	;XXYY,Sprite
	
	
	
	ifndef SpriteData_Bat1

SpriteData_Bat2:	
SpriteData_Bat1:
		db 1,3		;Width,Height
		db 1,2,3	;patterns (0=unused tile)
	
SpriteData_Ball:
		db 1,1		;Width,Height
		db 4		;patterns (0=unused tile)
	
	endif
	

vm_Traps:
	dw TestProgram
vm_AddressRemapTable:	

	ifdef BuildBBC
		include "\SrcBBC\BBC_V1_NativeSprite.asm"
	endif
	ifdef BuildA52
		include "\SrcA52\A52_V1_NativeSprite.asm"
	endif
	ifdef BuildA80
		include "\SrcA52\A52_V1_NativeSprite.asm"
	endif
	ifdef BuildAP2
		include "\SrcAP2\AP2_V1_NativeSprite.asm"
	endif
	ifdef BuildC64
		include "\SrcC64\C64_V1_NativeSprite.asm"
	endif
	ifdef BuildLNX
		include "\SrcLNX\LNX_V1_NativeSprite.asm"
	endif	
	ifdef BuildNES
		include "\SrcNES\NES_V1_NativeSprite.asm"
	endif	
	ifdef BuildSNS
		include "\SrcSNS\SNS_V1_NativeSprite.asm"
	endif	
	ifdef BuildPCE
		include "\SrcPCE\PCE_V1_NativeSprite.asm"
	endif
	
	
	include "\Sources\ReiKou\Reikou_ALL_NativeSprite.asm"
	

	include "\SrcALL\ChibiVm_CPU.asm"
	include "\Sources\ChibiVM\ChibiVM_AdventureEngine.asm"
	include "\Sources\ChibiVM\ChibiVM_Host.asm"
	
	include "monitor.asm"		
	include "core.asm"	
	
	include "footer.asm"
 
;                                     	ret
	;db rtsb
	