C64_FourColor equ 1
PCE_Use4ColorFont equ 1
SNS_Use4ColorFont equ 1
;NES_UseTileBuffer equ 1
;NES_UseSpriteBuffer equ 1


VM_RamBase equ ramarea+$100
VM_StackTop equ VM_RamBase+$100


;vm_useVMEM equ 1			;Enable Virtual address remapper

	include "\SrcALL\ChibiVm_InstSet.asm"

	;Basic macros for ASM tasks
	include "\SrcAll\BasicMacros.asm"

;z_Regs 		equ $70
SPpage equ $0100



	include "header.asm"
	
	jsr ChibiVM_Init
	
;ShowVMMonitor equ 1
		
	
InfLoop:	
	jsr VM_Tick

	;lda #0
	;sta VDP_Update
		
	;jsr WaitForFire
	
	jmp InfLoop



	ifdef ShowVMMonitor
		lda #0
		sta z_CursorX
		lda #12
		sta z_CursorY

	
;ZeroPage
		jsr MemDump			;Show Some Ram to screen
		word VM_RamBase     ;Address to show
		byte $3         	;Lines
	
	
;Stack
		jsr MemDump			;Show Some Ram to screen
		word VM_StackTop-16 ;Address to show
		byte $2        		;Lines
	
;Program
		lda VM_RamBase+VM_rPC
		sta t_MemdumpL
		lda VM_RamBase+VM_rPC+1
		sta t_MemdumpH
		ldx #1
		jsr MemDumpDirect
	endif
	
	jsr VM_Tick

	;jsr WaitForFire
	
	jmp InfLoop


;	org $1000
	
;FU records stage being run.
;OK = no problems
;NG = No Good - Problem occurred at stage marked by FU register
	

	Macro AdvCall,p1
		dbb SYSi,syscallAdventure
		db \p1
	endm
	
	
		
ballpos equ			ramarea+16
ballmove equ		ramarea+18
PlayerPaddle equ	ramarea+20
CpuPaddle equ		ramarea+22
PlayerScore equ		ramarea+24
CpuScore equ		ramarea+25
GameTick equ		ramarea+26
GameSpeed equ		ramarea+27		
GameAI equ			ramarea+28
SoundByte equ		ramarea+29 

	;org $800
TestProgram:
;                                     

;                                     newgame:
newgame:
;                                     	call cls
	advcall acls
;                                     	ld hl,$0000
	dbbw mov16x,r6_imm16,$0000
;                                     titlescreen:
titlescreen:
;                                     	call pause50
	advcall apause50
;                                     	ld de,$0000
	dbbw mov16x,r4_imm16,$0000
;                                     	push hl
	db ph6b
;                                     		ld hl,strstart
	dbbw mov16x,r6_imm16,strstart
;                                     		call printseq	
	advcall aprintseq
;                                     		ld hl,strspeed
	dbbw mov16x,r6_imm16,strspeed
;                                     		call printseq	
	advcall aprintseq
;                                     	pop hl
	db pl6b
;                                     	ld a,h
	dbbb movx,r0_zeropg,r7
;                                     	call showdecimal
	advcall ashowdecimal
;                                     

;                                     	push hl
	db ph6b
;                                     		ld hl,strai
	dbbw mov16x,r6_imm16,strai
;                                     		call printseq	
	advcall aprintseq
;                                     	pop hl
	db pl6b
;                                     	ld a,l
	dbb movx,r0_r6
;                                     	call showdecimal
	advcall ashowdecimal
;                                     

;                                     	call readjoystick
	advcall areadjoystick
;                                     	ld c,a
	dbb movx,r2_r0
;                                     

;                                     	ld de,$0004		;range
	dbbw mov16x,r4_imm16,$0004
;                                     	ld a,l
	dbb movx,r0_r6
;                                     	call joyaxis		;up/down
	advcall ajoyaxis
;                                     	call rangelimit	
	advcall arangelimit
;                                     	ld l,a
	dbb movx,r6_r0
;                                     	ld a,h
	dbbb movx,r0_zeropg,r7
;                                     	call joyaxis		;left/right
	advcall ajoyaxis
;                                     	call rangelimit	
	advcall arangelimit
;                                     	ld h,a
	dbbb movx,zeropg_r0,r7
;                                     

;                                     	bit 0,c
	dbbb tstx,r2_imm8,1
;                                     	jr nz,titlescreen
	dbw bnej,titlescreen
;                                     

;                                     	ld a,h
	dbbb movx,r0_zeropg,r7
;                                     	call readmask
	dbw bsrj,readmask
;                                     	ld (gamespeed),a
	dbbw stox,r0_addr16,gamespeed
;                                     

;                                     	ld a,l
	dbb movx,r0_r6
;                                     	call readmask
	dbw bsrj,readmask
;                                     	ld (gameai),a
	dbbw stox,r0_addr16,gameai
;                                     

;                                     	call rezeroball			;init ball pos (center)
	dbw bsrj,rezeroball
;                                     	ld a,e
	dbb movx,r0_r4
;                                     	ld (ballpos),a
	dbbw stox,r0_addr16,ballpos
;                                     	ld a,d
	dbbb movx,r0_zeropg,r5
;                                     	ld (ballpos+1),a
	dbbw stox,r0_addr16,ballpos+1
;                                     	

;                                     	ld a,$ff				;ball pos -1 = facing player
	dbb movi,$ff
;                                     	ld (ballmove),a
	dbbw stox,r0_addr16,ballmove
;                                     	ld (ballmove+1),a
	dbbw stox,r0_addr16,ballmove+1
;                                     

;                                     	ld a,6
	dbb movi,6
;                                     	ld (playerpaddle),a		;ypos
	dbbw stox,r0_addr16,playerpaddle
;                                     	ld (cpupaddle),a
	dbbw stox,r0_addr16,cpupaddle
;                                     	

;                                     	ld a,0
	dbb movi,0
;                                     	ld (cpuscore),a
	dbbw stox,r0_addr16,cpuscore
;                                     	ld (playerscore),a
	dbbw stox,r0_addr16,playerscore
;                                     		

;                                     	ld (playerpaddle+1),a	;cpos
	dbbw stox,r0_addr16,playerpaddle+1
;                                     	ld a,19
	dbb movi,19
;                                     	ld (cpupaddle+1),a
	dbbw stox,r0_addr16,cpupaddle+1
;                                     

;                                     	call cls
	advcall acls
;                                     	ld hl,strwall
	dbbw mov16x,r6_imm16,strwall
;                                     	call printseq			;draw walls
	advcall aprintseq
;                                     

;                                     	

;                                     gameloop:
gameloop:
;                                     	ld a,(ballpos)				;de=ball pos x,y
	dbbw movx,r0_addr16,ballpos
;                                     	ld e,a
	dbb movx,r4_r0
;                                     	ld a,(ballpos+1)
	dbbw movx,r0_addr16,ballpos+1
;                                     	ld d,a
	dbbb movx,zeropg_r0,r5
;                                     	push de
	db ph4b
;                                     		ld a,'o'
	dbb movi,'o'
;                                     		call printchar			;draw ball
	advcall aprintchar
;                                     

;                                     

;                                     		call getplayerpaddlede
	dbw bsrj,getplayerpaddlede
;                                     		call drawpaddle			;draw player paddle
	dbw bsrj,drawpaddle
;                                     

;                                     		call getcpupaddlede
	dbw bsrj,getcpupaddlede
;                                     		call drawpaddle			;draw cpu paddle
	dbw bsrj,drawpaddle
;                                     

;                                     		ld de,$0011
	dbbw mov16x,r4_imm16,$0011
;                                     		ld a,(playerscore)		;show player score
	dbbw movx,r0_addr16,playerscore
;                                     		call showdecimal
	advcall ashowdecimal
;                                     

;                                     		ld de,$1111
	dbbw mov16x,r4_imm16,$1111
;                                     		ld a,(cpuscore)			;show cpu score
	dbbw movx,r0_addr16,cpuscore
;                                     		call showdecimal
	advcall ashowdecimal
;                                     	

;                                     		ld a,(soundbyte)
	dbbw movx,r0_addr16,soundbyte
;                                     		call chibisound			;play sound
	advcall achibisound
;                                     	

;                                     		call pause50			;wait a bit
	advcall apause50
;                                     

;                                     		ld a,0
	dbb movi,0
;                                     		ld (soundbyte),a
	dbbw stox,r0_addr16,soundbyte
;                                     	pop de
	db pl4b
;                                     	push de
	db ph4b
;                                     		ld a,' '
	dbb movi,' '
;                                     		call printchar		;remove ball
	advcall aprintchar
;                                     	pop de
	db pl4b
;                                     

;                                     	ld a,(gamespeed)			;l=game speed mask
	dbbw movx,r0_addr16,gamespeed
;                                     	ld l,a
	dbb movx,r6_r0
;                                     

;                                     	ld a,(ballmove)				;bc=ball move x,y
	dbbw movx,r0_addr16,ballmove
;                                     	ld c,a
	dbb movx,r2_r0
;                                     	ld a,(ballmove+1)
	dbbw movx,r0_addr16,ballmove+1
;                                     	ld b,a
	dbb movx,r3_r0
;                                     	

;                                     	ld a,(gametick)
	dbbw movx,r0_addr16,gametick
;                                     	inc a
	db incb
;                                     	ld (gametick),a
	dbbw stox,r0_addr16,gametick
;                                     	and l						;move speed mask
	dbb andz,r6
;                                     	call z,moveball				;update ball pos
	dbb bnei,3
	dbw bsrj,moveball
lbl53141
;                                     

;                                     	call getplayerpaddlede
	dbw bsrj,getplayerpaddlede
;                                     	

;                                     	call readjoystick
	advcall areadjoystick
;                                     	ld c,a
	dbb movx,r2_r0
;                                     	call processpaddle			;move paddle from player input
	dbw bsrj,processpaddle
;                                     	

;                                     	ld a,l
	dbb movx,r0_r6
;                                     	ld (playerpaddle),a
	dbbw stox,r0_addr16,playerpaddle
;                                     	ld a,h
	dbbb movx,r0_zeropg,r7
;                                     	ld (playerpaddle+1),a
	dbbw stox,r0_addr16,playerpaddle+1
;                                     

;                                     	call getcpupaddlede
	dbw bsrj,getcpupaddlede
;                                     	

;                                     	ld a,(gameai)
	dbbw movx,r0_addr16,gameai
;                                     	ld l,a
	dbb movx,r6_r0
;                                     

;                                     	ld a,(gametick)
	dbbw movx,r0_addr16,gametick
;                                     	and l			;make cpu dumber
	dbb andz,r6
;                                     	jr nz,cpudecided
	dbw bnej,cpudecided
;                                     

;                                     	ld c,%11111111		;nomove
	dbbb movx,r2_imm8,%11111111
;                                     

;                                     	ld a,(ballpos)
	dbbw movx,r0_addr16,ballpos
;                                     	sub 1
	dbb subi,1
;                                     	cp e
	dbb cmpz,r4
;                                     	jr z,cpudecided	;no move
	dbw beqj,cpudecided
;                                     

;                                     	jr c,cpuup		;move up
	dbw bcsj,cpuup
;                                     	ld c,%11111101		;move down
	dbbb movx,r2_imm8,%11111101
;                                     	jr cpudecided
	dbb brai,cpudecided-lbl33183
lbl33183
;                                     cpuup:
cpuup:
;                                     	ld c,%11111110	
	dbbb movx,r2_imm8,%11111110
;                                     cpudecided:
cpudecided:
;                                     	call processpaddle		;move paddle from cpu ai
	dbw bsrj,processpaddle
;                                     	

;                                     	ld a,l
	dbb movx,r0_r6
;                                     	ld (cpupaddle),a
	dbbw stox,r0_addr16,cpupaddle
;                                     	ld a,h
	dbbb movx,r0_zeropg,r7
;                                     	ld (cpupaddle+1),a
	dbbw stox,r0_addr16,cpupaddle+1
;                                     

;                                     	ld a,(cpuscore)
	dbbw movx,r0_addr16,cpuscore
;                                     	ld hl,playerscore
	dbbw mov16x,r6_imm16,playerscore
;                                     	or (hl)
	dbb orrx,r0_atr6
;                                     	cp 8
	dbb cmpi,8
;                                     	jp c,gameloop		;anyone reached 8 points?
	dbw bcsj,gameloop
;                                     

;                                     	ld hl,strgameover
	dbbw mov16x,r6_imm16,strgameover
;                                     	ld de,$0608
	dbbw mov16x,r4_imm16,$0608
;                                     	call printseq
	advcall aprintseq
;                                     

;                                     	call waitforfire
	advcall awaitforfire
;                                     	jp newgame
	dbw braj,newgame
;                                     

;                                     	

;                                     getplayerpaddlede:
getplayerpaddlede:
;                                     	ld a,(playerpaddle)		;could just use ld de,(playerpaddle) on non gb
	dbbw movx,r0_addr16,playerpaddle
;                                     	ld e,a
	dbb movx,r4_r0
;                                     	ld a,(playerpaddle+1)
	dbbw movx,r0_addr16,playerpaddle+1
;                                     	ld d,a
	dbbb movx,zeropg_r0,r5
;                                     	ret	
	db rtsb
;                                     

;                                     	

;                                     getcpupaddlede:
getcpupaddlede:
;                                     	ld a,(cpupaddle)		;could just use ld de,(cpupaddle) on non gb
	dbbw movx,r0_addr16,cpupaddle
;                                     	ld e,a
	dbb movx,r4_r0
;                                     	ld a,(cpupaddle+1)
	dbbw movx,r0_addr16,cpupaddle+1
;                                     	ld d,a
	dbbb movx,zeropg_r0,r5
;                                     	ret	
	db rtsb
;                                     

;                                     	

;                                     moveball:
moveball:
;                                     	ld a,%10100000
	dbb movi,%10100000
;                                     	ld (soundbyte),a
	dbbw stox,r0_addr16,soundbyte
;                                     

;                                     	ld a,(playerpaddle)
	dbbw movx,r0_addr16,playerpaddle
;                                     	ld l,a
	dbb movx,r6_r0
;                                     	ld a,(playerpaddle+1)
	dbbw movx,r0_addr16,playerpaddle+1
;                                     	ld h,a
	dbbb movx,zeropg_r0,r7
;                                     	

;                                     	ld a,d		
	dbbb movx,r0_zeropg,r5
;                                     	cp 1					;hit player paddle
	dbb cmpi,1
;                                     	jr nz,noplayerpaddlehit
	dbw bnej,noplayerpaddlehit
;                                     	call z,paddletest
	dbb bnei,3
	dbw bsrj,paddletest
lbl30054
;                                     	call c,cpuscores		;carry=missed paddle
	dbb bcci,3
	dbw bsrj,cpuscores
lbl63924
;                                     noplayerpaddlehit:
noplayerpaddlehit:
;                                     

;                                     	ld a,(cpupaddle)
	dbbw movx,r0_addr16,cpupaddle
;                                     	ld l,a
	dbb movx,r6_r0
;                                     	ld a,(cpupaddle+1)
	dbbw movx,r0_addr16,cpupaddle+1
;                                     	ld h,a
	dbbb movx,zeropg_r0,r7
;                                     	ld a,d	
	dbbb movx,r0_zeropg,r5
;                                     	cp 18					;hit cpu paddle
	dbb cmpi,18
;                                     	jr nz,nocpupaddlehit
	dbw bnej,nocpupaddlehit
;                                     	call z,paddletest
	dbb bnei,3
	dbw bsrj,paddletest
lbl22357
;                                     	call c,playerscores
	dbb bcci,3
	dbw bsrj,playerscores
lbl32009
;                                     nocpupaddlehit:
nocpupaddlehit:
;                                     

;                                     	ld a,d
	dbbb movx,r0_zeropg,r5
;                                     	add b			;update ball xpos
	dbb addz,r3
;                                     	ld d,a	
	dbbb movx,zeropg_r0,r5
;                                     

;                                     	ld a,e
	dbb movx,r0_r4
;                                     	add c			;update ball ypos
	dbb addz,r2
;                                     	ld e,a
	dbb movx,r4_r0
;                                     	

;                                     	cp 1			;hit top wall
	dbb cmpi,1
;                                     	call z,flipy
	dbb bnei,3
	dbw bsrj,flipy
lbl7477
;                                     	cp 16			;hit bottom wall
	dbb cmpi,16
;                                     	call z,flipy
	dbb bnei,3
	dbw bsrj,flipy
lbl34204
;                                     

;                                     	ld a,e
	dbb movx,r0_r4
;                                     	ld (ballpos),a
	dbbw stox,r0_addr16,ballpos
;                                     	ld a,d
	dbbb movx,r0_zeropg,r5
;                                     	ld (ballpos+1),a
	dbbw stox,r0_addr16,ballpos+1
;                                     	

;                                     	ld a,c
	dbb movx,r0_r2
;                                     	ld (ballmove),a
	dbbw stox,r0_addr16,ballmove
;                                     	ld a,b
	dbb movx,r0_r3
;                                     	ld (ballmove+1),a
	dbbw stox,r0_addr16,ballmove+1
;                                     	ret
	db rtsb
;                                     

;                                     	

;                                     paddletest:		;carry=missed paddle
paddletest:
;                                     	ld a,e
	dbb movx,r0_r4
;                                     	cp l
	dbb cmpz,r6
;                                     	jr c,paddlemiss
	dbw bcsj,paddlemiss
;                                     	sub 3
	dbb subi,3
;                                     	cp l
	dbb cmpz,r6
;                                     	jr nc,paddlemiss
	dbw bccj,paddlemiss
;                                     	call flipx
	dbw bsrj,flipx
;                                     

;                                     	ld a,%01000000
	dbb movi,%01000000
;                                     	ld (soundbyte),a
	dbbw stox,r0_addr16,soundbyte
;                                     	or a		;clear carry
	dbb orrz,r0
;                                     	ret
	db rtsb
;                                     	

;                                     	

;                                     paddlemiss:
paddlemiss:
;                                     	ld a,%01110000
	dbb movi,%01110000
;                                     	ld (soundbyte),a
	dbbw stox,r0_addr16,soundbyte
;                                     	scf		;set carry
	dbbb movx,rF_imm8,3
;                                     	ret
	db rtsb
;                                     	

;                                     cpuscores:
cpuscores:
;                                     	ld hl,cpuscore
	dbbw mov16x,r6_imm16,cpuscore
;                                     	inc (hl)
	dbb incx,atr6_atr6
;                                     	call rezeroball
	dbw bsrj,rezeroball
;                                     	ret
	db rtsb
;                                     

;                                     	

;                                     playerscores:
playerscores:
;                                     	ld hl,playerscore
	dbbw mov16x,r6_imm16,playerscore
;                                     	inc (hl)
	dbb incx,atr6_atr6
;                                     					;rezero ball

;                                     rezeroball:
rezeroball:
;                                     	ld de,$0a08
	dbbw mov16x,r4_imm16,$0a08
;                                     					;flip direction of ball

;                                     flipx:	
flipx:
;                                     	ld a,b
	dbb movx,r0_r3
;                                     	cpl ;neg
	dbb xori,255
;                                     	inc a
	db incb
;                                     	ld b,a
	dbb movx,r3_r0
;                                     	ret
	db rtsb
;                                     

;                                     	

;                                     flipy:
flipy:
;                                     	ld a,c
	dbb movx,r0_r2
;                                     	cpl ;neg
	dbb xori,255
;                                     	inc a
	db incb
;                                     	ld c,a
	dbb movx,r2_r0
;                                     	ret
	db rtsb
;                                     

;                                     	

;                                     drawpaddle:
drawpaddle:
;                                     	ld hl,strpaddle
	dbbw mov16x,r6_imm16,strpaddle
;                                     	call printseq
	advcall aprintseq
;                                     	ret
	db rtsb
;                                     

;                                     	

;                                     processpaddle:
processpaddle:
;                                     	push de
	db ph4b
;                                     	push bc
	db ph2b
;                                     		ld hl,strblankpaddle
	dbbw mov16x,r6_imm16,strblankpaddle
;                                     		call printseq
	advcall aprintseq
;                                     	pop bc
	db pl2b
;                                     	pop hl
	db pl6b
;                                     

;                                     	ld de,$010f
	dbbw mov16x,r4_imm16,$010f
;                                     	ld a,l
	dbb movx,r0_r6
;                                     	call joyaxis		;up/down
	advcall ajoyaxis
;                                     	call rangelimit	
	advcall arangelimit
;                                     	ld l,a
	dbb movx,r6_r0
;                                     	ret
	db rtsb
;                                     

;                                     	

;                                     readmask:
readmask:
;                                     	push hl
	db ph6b
;                                     		ld hl,masks
	dbbw mov16x,r6_imm16,masks
;                                     		ld d,0
	dbbbb movx,zeropg_imm8,r5,0
;                                     		ld e,a
	dbb movx,r4_r0
;                                     		add hl,de
	dbb add16x,r6_r4
;                                     		ld a,(hl)
	dbb movx,r0_atr6
;                                     	pop hl
	db pl6b
	db rtsb
;                                     

;Speed masks for ball and AI	
Masks:	db %00000111,%00000011,%00000001,%00000000


strGameOver:db 'Game Over',255
strStart:	db 'Pongo!',253,255

strSpeed:	db 253,'Speed:',255
strAi:		db 253,'AI:',255

strWall:	 db $B3,'-',253,$F1	;253=Newline (Xpos=0) $F1= Ypos=17
			 db $B3,'-',255		;$B3=18 char H strip

strPaddle: 	 	 db $C2,'X',255 ;$C2=3 char V strip
strBlankPaddle:  db $C2,' ',255



vm_Traps:
	dw TestProgram
vm_AddressRemapTable:	

	include "\SrcALL\ChibiVm_CPU.asm"
	include "\Sources\ChibiVM\ChibiVM_AdventureEngine.asm"
	include "\Sources\ChibiVM\ChibiVM_Host.asm"
	
	include "monitor.asm"		
	include "core.asm"	
	include "footer.asm"
 
;                                     	ret
	;db rtsb