LNX_UsePalette equ 1
NES_BMPscreen equ 1
PCE_BMPscreen equ 1
SNS_BMPscreen equ 1

;SNS_BMPscreen_UseBuffer equ 1
;SNS_BMPscreen_UseBuffer_4Color equ 1

C64_FourColor equ 1
;C64_FourColor_HalfRes equ 1

;A52_FourColor equ 1
;A52_FourColor_HalfRes equ 1

VM_RamBase equ ramarea+$100
VM_StackTop equ VM_RamBase+$100

tempbuffer equ ramarea+128


	
	Macro MBcall,p1
		dbb SYSi,syscallMB
		db \p1
	endm
	Macro NSCall,p1
		dbb SYSi,syscallNS
		db \p1
	endm
	
VscreenMinX equ 64		;Top left of visible screen in logical co-ordinates
VscreenMinY equ 80

VscreenWid equ 128		;Visible Screen Size in logical units
VscreenHei equ 96
	
SpritePatternSize equ 32

BBC_NativeSprite_PatternOffset equ -1
A52_NativeSprite_PatternOffset equ -1
AP2_NativeSprite_PatternOffset equ -1
LNX_NativeSprite_PatternOffset equ -1

NES_SpritePatternCount equ 32
NES_SpritePatternVram equ $1000
	;ifdef BuildNES
; VDP_L equ z_Regs+18			;Position of next Tile in buffer L
; VDP_H equ z_Regs+19			;Position of next Tile in buffer H
; VDP_Update equ z_Regs+20	;VDP Update Flag
; VDPBuffer equ $300				;$400 byte Tilemap Buffer
; SpriteBuffer equ $200	;$100 byte Sprite data (64 sprites)
NES_UseTileBuffer equ 1
NES_UseSpriteBuffer equ 1
NES_Sprite8x16 equ 1
	;endif
	
C64_SpritePatternCount equ 32
C64_SpritePatternVram equ $5000	;Scrbase+$1000

SNS_SpriteSize0 equ 0
SNS_SpriteSize equ 0*32	

SnesSpriteBuffer equ $0A00 	;Sprite buffer at $0A00+ ($220 bytes)
SNS_SpritePatternCount equ 128
SNS_SpritePatternVram equ $4000

PCE_SpritePatternCount equ 32
PCE_SpritePatternVram equ $2000


;vm_useVMEM equ 1			;Enable Virtual address remapper

	include "\SrcALL\ChibiVm_InstSet.asm"

	;Basic macros for ASM tasks
	include "\SrcAll\BasicMacros.asm"

;z_Regs 		equ $70
SPpage equ $0100



	include "header.asm"
	
	; loadpair z_hl,SpriteArray
	; loadpair z_de,SpriteArrayRam
	; loadpair z_bc,32
	; jsr DoLdir
	
	
	jsr ChibiVM_Init
	
;ShowVMMonitor equ 1
		
	; loadpair z_hl,SpritePatterns
	; jsr NativeSpr_Init
	
	; loadpair z_hl,SpriteArray
	; jsr NativeSpr_DrawArray
	
	; jsr nativespr_hidearray
	
	; jmp *
	
InfLoop:	

	jsr VM_Tick

	;jsr WaitForFire

	


	ifdef ShowVMMonitor
		lda #0
		sta z_CursorX
		sta z_d
		lda #0
		sta z_e
		sta z_CursorY

	
;ZeroPage
		jsr MemDump			;Show Some Ram to screen
		word VM_RamBase     ;Address to show
		byte $2         	;Lines
	
	
;Stack
		jsr MemDump			;Show Some Ram to screen
		word VM_StackTop-16 ;Address to show
		byte $2        		;Lines
	
;Program
		lda VM_RamBase+VM_rPC
		sta t_MemdumpL
		lda VM_RamBase+VM_rPC+1
		sta t_MemdumpH
		ldx #1
		jsr MemDumpDirect
	endif
	
	

	;jsr VM_Tick

	;jsr WaitForFire
	
	jmp InfLoop
	

;	org $1000
	
;FU records stage being run.
;OK = no problems
;NG = No Good - Problem occurred at stage marked by FU register
	

	Macro AdvCall,p1
		dbb SYSi,syscallAdventure
		db \p1
	endm
	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
		
	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
		
	;org &800
TestProgram:
	;dbw braj,TileTest
;                                     

;                                         ld b,191
	dbbb movx,r3_imm8,191
;                                     testagain:    
testagain:
;                                         ld a,b
	dbb movx,r0_r3
;                                         rrca
	db asrb
;                                         rrca
	db asrb
;                                         rrca
	db asrb
;                                         ;rrca

;                                         and %00001111
	dbb andi,%00001111
;                                         ld d,b
	dbbb movx,zeropg_r3,r5
;                                         ld e,b
	dbb movx,r4_r3
;                                         ld l,0                ;ld = xpos e=ypos
	dbbb movx,r6_imm8,0
;                                         push bc
	;db ph2b
;                                             call mpbitmap_setpixel
	;dbw bsrj,mpbitmap_setpixel
	
	MBcall mbSetpixel					;Diagonal line
;                                         pop bc
	;db pl2b
;                                         

;                                         

;                                         

;                                         ld a,b
	dbb movx,r0_r3
;                                         rrca
	db asrb
;                                         rrca
	db asrb
;                                         rrca
	db asrb
;                                         ;rrca

;                                         and %00001111
	dbb andi,%00001111
;                                         ld d,b
	dbbb movx,zeropg_r3,r5
;                                         ld e,b
	dbb movx,r4_r3
;                                         srl e
    dbb lsrz,r4
;                                         srl e
    dbb lsrz,r4
;                                         srl e
    dbb lsrz,r4
;                                         ld l,0
	dbbb movx,r6_imm8,0
;                                         

;                                         push bc
;	db ph2b
;                                             call mpbitmap_setpixel
	;dbw bsrj,mpbitmap_setpixel
	MBcall mbSetpixel
;                                         pop bc
	;db pl2b
;                                         

;                                         ld d,b
	dbbb movx,zeropg_r3,r5
;                                         ld e,b
	dbb movx,r4_r3
;                                         ld l,0
	dbbb movx,r6_imm8,0
;                                         

;                                         push bc
	;db ph2b
;                                             call mpbitmap_getpixel
	dbb movi,1
	;dbw bsrj,mpbitmap_getpixel
	MBcall mbGetpixel
;                                         pop bc
	;db pl2b
;                                         inc a
	db incb
;                                         ld d,b
	dbbb movx,zeropg_r3,r5
;                                         inc d
	dbb incz,r5
;                                         inc d 
	dbb incz,r5
;                                         inc d
	dbb incz,r5
;                                         ld e,b
	dbb movx,r4_r3
;                                         ld l,0
	dbbb movx,r6_imm8,0
;                                         push bc
	;db ph2b
;                                             call mpbitmap_setpixel
	;dbw bsrj,mpbitmap_setpixel
	MBcall mbSetpixel
;                                         pop bc
	;db pl2b
;                                         

;                                         

;                                         djnz testagain
	dbb decz,r3
	dbw bnej,testagain

	
TileTest:	
	
	dbbw mov16x,r6_imm16,bitmap2bitplane
;                                         ld de,&0010
	dbbw mov16x,r4_imm16,$0010
	dbbw mov16x,r4_imm16,$0000
	
;                                             

;                                         ld c,6
	dbbb movx,r2_imm8,6
;                                     tiletestagainy3:    
tiletestagainy3:
;                                         ld b,6
	dbbb movx,r3_imm8,6
;                                     tiletestagainx3:    
tiletestagainx3:
;                                         ld a,2
	dbb movi,2
;                                         push bc
	db ph2b
;                                         push de
	db ph4b
;                                             call mpbitmap_settile
	;dbw bsrj,mpbitmap_settile
	MBcall mbSettile
;                                         pop de
	db pl4b
;                                         inc d
	dbb incz,r5
;                                         pop bc
	db pl2b
;                                         djnz tiletestagainx3
	dbb decz,r3
	dbw bnej,tiletestagainx3
;                                         ld d,0
	dbbbb movx,zeropg_imm8,r5,0
;                                         inc e
	dbb incz,r4
;                                         dec c
	dbb decz,r2
;                                         jr nz,tiletestagainy3
	dbb bnei,tiletestagainy3-lbl_1CD7xD783
lbl_1CD7xD783
;                                         

;                                         

;                                         ld hl,bitmap4bitplane
	dbbw mov16x,r6_imm16,bitmap4bitplane
;                                         ld de,&0008
	dbbw mov16x,r4_imm16,$0008
;                                             

;                                         ld c,6
	dbbb movx,r2_imm8,6
;                                     tiletestagainy:    
tiletestagainy:
;                                         ld b,6
	dbbb movx,r3_imm8,6
;                                     tiletestagainx:    
tiletestagainx:
;                                         ld a,4
	dbb movi,4
;                                         push bc
	db ph2b
;                                         push de
	db ph4b
;                                             call mpbitmap_settile
	;dbw bsrj,mpbitmap_settile
	MBcall mbSettile
;                                         pop de
	db pl4b
;                                         inc d
	dbb incz,r5
;                                         pop bc
	db pl2b
;                                         djnz tiletestagainx
	dbb decz,r3
	dbw bnej,tiletestagainx
;                                         ld d,0
	dbbbb movx,zeropg_imm8,r5,0
;                                         inc e
	dbb incz,r4
;                                         dec c
	dbb decz,r2
;                                         jr nz,tiletestagainy
	dbb bnei,tiletestagainy-lbl_9803x75B7
lbl_9803x75B7
;                                         

;                                         

;                                         ld de,&0008
	dbbw mov16x,r4_imm16,$0008
;                                         ld c,6
	dbbb movx,r2_imm8,6
;                                     tiletestagainy2:    
tiletestagainy2:
;                                         ld b,6
	dbbb movx,r3_imm8,6
;                                     tiletestagainx2:    
tiletestagainx2:
;                                         

;                                         push bc
	db ph2b
;                                         push de
	db ph4b
;                                             push de
	db ph4b
;                                                 ld hl,tempbuffer
	dbbw mov16x,r6_imm16,tempbuffer
;                                                 ld a,1
	dbb movi,1
	MBcall mbGettile
;                                             pop de
	db pl4b
;                                             ld hl,tempbuffer
	dbbw mov16x,r6_imm16,tempbuffer
;                                             ld a,d
	dbbb movx,r0_zeropg,r5
;                                             add 24
	dbb addi,12
;                                             ld d,a
	dbbb movx,zeropg_r0,r5
;                                             

;                                             

;                                             ld a,1
	dbb movi,1
	MBcall mbSettile
;                                         pop de
	db pl4b
;                                         inc d
	dbb incz,r5
;                                         pop bc
	db pl2b
;                                         djnz tiletestagainx2
	dbb decz,r3
	dbw bnej,tiletestagainx2
;                                         ld d,0
	dbbbb movx,zeropg_imm8,r5,0
;                                         inc e
	dbb incz,r4
;                                         dec c
	dbb decz,r2
;                                         jr nz,tiletestagainy2
	dbb bnei,tiletestagainy2-lbl_7409xD7E8
lbl_7409xD7E8
;                                         

;                                     

	db hltb
	

	include "\Sources\ReiKou\Reikou_ALL_MultiplatformBitmap.asm"
	
Bitmap2bitplane:
	incbin "\ResALL\Sprites\RawGB.RAW"
	
Bitmap4bitplane:
	incbin "\ResALL\Sprites\RawSMS_16Color.RAW"
	

	include "\srcALL\V1_MultiplatformBitmap.asm"
	
	

vm_Traps:
	dw TestProgram
vm_AddressRemapTable:	


LNX_palette:
	dw $0000; ;0  -GBR
	dw $0088; ;1  -GBR
	dw $0FF0; ;2  -GBR
	dw $0FFF; ;3  -GBR
	dw $0048; ;4  -GBR
	dw $0880; ;5  -GBR
	dw $08F8; ;6  -GBR
	dw $000F; ;7  -GBR
	dw $0F40; ;8  -GBR
	dw $07CF; ;9  -GBR
	dw $08F8; ;10  -GBR
	dw $00F0; ;11  -GBR
	dw $0800; ;12  -GBR
	dw $0E6B; ;13  -GBR
	dw $008F; ;14  -GBR
	dw $0FFF; ;15  -GBR


	include "\SrcALL\ChibiVm_CPU.asm"
	include "\Sources\ChibiVM\ChibiVM_AdventureEngine.asm"
	include "\Sources\ChibiVM\ChibiVM_Host.asm"
	
	include "monitor.asm"		
	include "core.asm"	
	
	include "footer.asm"
 
;                                     	ret
	;db rtsb
	