
ramarea equ $400		;Define some space for program vars
						;First 16 bytes reserved for core.

z_Regs equ $20			;Used for fake Z80 register pairs
		
*=$0801		; BASIC program to boot the machine language code
	db $0E,$08,$0A,$00,$9E,$20,$28,$32,$30,$36,$34,$29,$00,$00,$00  
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;Set up the screen

	;	  LXMSHVVV - L=Cur Line X=extended BG M=mode (Txt/Bmp) 
	lda #%00111011	;S=screen on H=height V=Vert scroll
	sta $D011			;Turn on graphics mode
		
	;     ---MWHHH - M=Multicolor W=scr width H=horiz scroll
	ifdef C64_FourColor
		lda #%11011000  ;1=Multicolor 4 coor 
	else
		lda #%11001000  ;0=standard 2 color 
	endif
	sta $D016

	;     SSSSTTT- - T=Text/Bmp screen address S=Screen (color) address
	lda #%00011000  ;T=1 Screen at offset +$2000 S=Color offset at +400
	sta $D018		; (Other T bits have no function in bitmap mode)
	
	lda $DD00
	and #%11111100
	ora #%00000010	;Screen base at $4000 range (+$2000 = $6000)
	sta $DD00
	
;Define colors

	lda #%00000000	;%----CCCC
	sta $D021		;Background color (only bits #0-#3).
	sta $D020		;Border (A=0)
	
	jsr ClearRam	;Clear first 256 bytes of ram, and CLS
	
	
	
;Fill the color ram
	; tay				;A=0 Y=0
	; sta z_l
	; lda #$44		;Colors at $4400
	; sta z_h
		
	; ldx #4			;Fill $400 Bytes (Y=0)
	
	; lda #$30		;Cyan / Black
; FillColors:
	; sta (z_hl),y
	; iny				;L loop count
	; bne FillColors
	; inc z_h
	; dex 			;H Loop count
	; bne FillColors
	