
		
NewLine:
	lda #0		
	sta z_d			;Cursor X=0

	inc z_e			;Cursor Y++

	lda z_e
	cmp #23			;at bottom of screen?
	bcs Cls			;no? return, else cls!
	rts

Cls:
	lda z_h
	pha
	lda z_l
	pha
		lda z_b
		pha
		lda z_c
		pha
			lda #0
			sta z_d			;x,y
			sta z_e
			sta z_l			;char,inc
			lda #$20
			sta z_h

			lda #40			;width,height
			sta z_b
			lda #$19
			sta z_c

			jsr fillarea	;Clear the screen
		pla
		sta	z_c
		pla
		sta z_b
		
	pla
	sta	z_l
	pla
	sta z_h

slowdown:	;This exists for systems that run too fast
	rts


PrintNumber:		
	clc
	adc #48			;ascii 0

PrintChar:			;Print char A at loc D,E
	cmp #0
	bne Notprintchar0
		inc z_d		;0=Skip this char
		rts
Notprintchar0:	
	tay
	pha
	lda z_d
	pha
	lda z_e
	pha
	lda z_h
	pha
	lda z_l
	pha
	
;Calculate VRAM destination
		ldx #0
		stx z_h
		
		lda z_d			;Xpos in chars
		sta z_l

		stx z_As		;As=0
		stx z_D
			
		lda z_e			;Ypos in Chars
		asl				;40 bytes per Yline =00000000 00101000
		rol z_As
		asl
		rol z_As
		asl				;00000000 00101000
		rol z_As		;00000YYY YYyyy000	- Y*8
		tax 
			adc z_l		;Add part to total L
			sta z_l
			lda z_As	;Add part to total H
			adc z_h
			sta z_h
		txa 
		asl
		rol z_As
		asl				;00000000 00101000
		rol z_As		;000YYYYY yyy00000 - Y*32
		
		adc z_l			;Add part to total L
		sta z_l
		lda z_As		;Add part to total H
		adc z_h
		adc #$44		;$4400 = Color Map
		sta z_h
		
;Color 1/2 Foreground/Back (ScreenBase+$400)
		ldx #0
		
		ifdef C64_FourColor
			lda #$34		;Cyan/Purple
			sta (z_hl,x)	;Write to VRAM
			
			lda z_h
			clc
			adc #$D8-$44	;$D800 = Color mem
			sta z_h
		
	;Color 3 ($D800)
			lda #$01		;White
			sta (z_hl,x)	;Write to VRAM
		else
			lda #$30		;Cyan/Black
			sta (z_hl,x)	;Write to VRAM
		endif

;Calculate Bitmap VRAM
		lda z_h
		sec 
		ifdef C64_FourColor
			sbc #$D8		;Remove offset to color map
		else
			sbc #$44		;Remove offset to color map
		endif 
		asl z_l
		rol
		asl z_l
		rol
		asl z_l			;*8 (8 bytes/Lines per block)
		rol
		adc #$60		;Screen Base $4000+$2000=$6000
		sta z_h
				
;Calculate font source
		tya				;Y=Character to show
		sec
		sbc #32			;no char below 32
		cmp #64			
		bcc notlowercase ;Lowercase?
		sec
		sbc #32			;Convert to upper!
notlowercase:
		asl
		rol z_d			;8 bytes per character
		asl
		rol z_d
		asl
		rol z_d
		
		adc #<fontdata	;Add font base
		sta z_e
		lda z_d
		adc #>fontdata
		sta z_d
		
;Transfer Bitmap character
		ldy #8-1		;8 lines
	PrintCharByte:			
		lda (z_de),y	;Get a byte
		sta (z_hl),y	;Write to screen
		dey 
		bpl PrintCharByte
	pla
	sta	z_l
	pla
	sta z_h
	pla
	sta	z_e
	pla
	sta z_d
	
	pla
	inc z_d				;Xpos ++
	rts

	
	
ReadJoystick:			;%---FRLDU
	;lda $DC00			;Read in Joystick 2
	lda $DC01			;Read in Joystick 1
	rts
	
	
FontData:											
		db 0,0,0,0,0,0,0,0		;Space
	    DB $10,$18,$18,$18,$18,$00,$18,$00     ;  0
        DB $28,$6C,$28,$00,$00,$00,$00,$00     ;  1
        DB $00,$28,$7C,$28,$7C,$28,$00,$00     ;  2
        DB $18,$3E,$48,$3C,$12,$7C,$18,$00     ;  3
        DB $02,$C4,$C8,$10,$20,$46,$86,$00     ;  4
        DB $10,$28,$28,$72,$94,$8C,$72,$00     ;  5
        DB $0C,$1C,$30,$00,$00,$00,$00,$00     ;  6
        DB $18,$18,$30,$30,$30,$18,$18,$00     ;  7
        DB $18,$18,$0C,$0C,$0C,$18,$18,$00     ;  8
        DB $08,$49,$2A,$1C,$14,$22,$41,$00     ;  9
        DB $00,$18,$18,$7E,$18,$18,$00,$00     ; 10
        DB $00,$00,$00,$00,$00,$18,$18,$30     ; 11
        DB $00,$00,$00,$7E,$7E,$00,$00,$00     ; 12
        DB $00,$00,$00,$00,$00,$18,$18,$00     ; 13
        DB $02,$04,$08,$10,$20,$40,$80,$00     ; 14
        DB $7C,$C6,$D6,$D6,$D6,$C6,$7C,$00     ; 15
        DB $10,$18,$18,$18,$18,$18,$08,$00     ; 16
        DB $3C,$7E,$06,$3C,$60,$7E,$3C,$00     ; 17
        DB $3C,$7E,$06,$1C,$06,$7E,$3C,$00     ; 18
        DB $18,$3C,$64,$CC,$7C,$0C,$08,$00     ; 19
        DB $3C,$7E,$60,$7C,$06,$7E,$3E,$00     ; 20
        DB $3C,$7E,$60,$7C,$66,$66,$3C,$00     ; 21
        DB $3C,$7E,$06,$0C,$18,$18,$10,$00     ; 22
        DB $3C,$66,$66,$3C,$66,$66,$3C,$00     ; 23
        DB $3C,$66,$66,$3E,$06,$7E,$3C,$00     ; 24
        DB $00,$00,$18,$18,$00,$18,$18,$00     ; 25
        DB $00,$00,$18,$18,$00,$18,$18,$30     ; 26
        DB $0C,$1C,$38,$60,$38,$1C,$0C,$00     ; 27
        DB $00,$00,$7E,$00,$00,$7E,$00,$00     ; 28
        DB $60,$70,$38,$0C,$38,$70,$60,$00     ; 29
        DB $3C,$76,$06,$1C,$00,$18,$18,$00     ; 30
        DB $7C,$CE,$A6,$B6,$C6,$F0,$7C,$00     ; 31
        DB $18,$3C,$66,$66,$7E,$66,$24,$00     ; 32
        DB $3C,$66,$66,$7C,$66,$66,$3C,$00     ; 33
        DB $38,$7C,$C0,$C0,$C0,$7C,$38,$00     ; 34
        DB $3C,$64,$66,$66,$66,$64,$38,$00     ; 35
        DB $3C,$7E,$60,$78,$60,$7E,$3C,$00     ; 36
        DB $38,$7C,$60,$78,$60,$60,$20,$00     ; 37
        DB $3C,$66,$C0,$C0,$CC,$66,$3C,$00     ; 38
        DB $24,$66,$66,$7E,$66,$66,$24,$00     ; 39
        DB $10,$18,$18,$18,$18,$18,$08,$00     ; 40
        DB $08,$0C,$0C,$0C,$4C,$FC,$78,$00     ; 41
        DB $24,$66,$6C,$78,$6C,$66,$24,$00     ; 42
        DB $20,$60,$60,$60,$60,$7E,$3E,$00     ; 43
        DB $44,$EE,$FE,$D6,$D6,$D6,$44,$00     ; 44
        DB $44,$E6,$F6,$DE,$CE,$C6,$44,$00     ; 45
        DB $38,$6C,$C6,$C6,$C6,$6C,$38,$00     ; 46
        DB $38,$6C,$64,$7C,$60,$60,$20,$00     ; 47
        DB $38,$6C,$C6,$C6,$CA,$74,$3A,$00     ; 48
        DB $3C,$66,$66,$7C,$6C,$66,$26,$00     ; 49
        DB $3C,$7E,$60,$3C,$06,$7E,$3C,$00     ; 50
        DB $3C,$7E,$18,$18,$18,$18,$08,$00     ; 51
        DB $24,$66,$66,$66,$66,$66,$3C,$00     ; 52
        DB $24,$66,$66,$66,$66,$3C,$18,$00     ; 53
        DB $44,$C6,$D6,$D6,$FE,$EE,$44,$00     ; 54
        DB $C6,$6C,$38,$38,$6C,$C6,$44,$00     ; 55
        DB $24,$66,$66,$3C,$18,$18,$08,$00     ; 56
        DB $7C,$FC,$0C,$18,$30,$7E,$7C,$00     ; 57
        DB $1C,$30,$30,$30,$30,$30,$1C,$00     ; 58
        DB $80,$40,$20,$10,$08,$04,$02,$00     ; 59
        DB $38,$0C,$0C,$0C,$0C,$0C,$38,$00     ; 60
        DB $18,$3C,$7E,$18,$18,$18,$18,$00     ; 61
        DB $00,$00,$00,$00,$00,$00,$FF,$FF     ; 62
        DB $30,$18,$0C,$00,$00,$00,$00,$00     ; 63
        ; DB $00,$00,$38,$0C,$7C,$CC,$78,$00     ; 64
        ; DB $20,$60,$7C,$66,$66,$66,$3C,$00     ; 65
        ; DB $00,$00,$3C,$66,$60,$66,$3C,$00     ; 66
        ; DB $08,$0C,$7C,$CC,$CC,$CC,$78,$00     ; 67
        ; DB $00,$00,$3C,$66,$7E,$60,$3C,$00     ; 68
        ; DB $1C,$36,$30,$38,$30,$30,$10,$00     ; 69
        ; DB $00,$00,$3C,$66,$66,$3E,$06,$3C     ; 70
        ; DB $20,$60,$6C,$76,$66,$66,$24,$00     ; 71
        ; DB $18,$00,$18,$18,$18,$18,$08,$00     ; 72
        ; DB $06,$00,$04,$06,$06,$26,$66,$3C     ; 73
        ; DB $20,$60,$66,$6C,$78,$6C,$26,$00     ; 74
        ; DB $10,$18,$18,$18,$18,$18,$08,$00     ; 75
        ; DB $00,$00,$6C,$FE,$D6,$D6,$C6,$00     ; 76
        ; DB $00,$00,$3C,$66,$66,$66,$24,$00     ; 77
        ; DB $00,$00,$3C,$66,$66,$66,$3C,$00     ; 78
        ; DB $00,$00,$3C,$66,$66,$7C,$60,$20     ; 79
        ; DB $00,$00,$78,$CC,$CC,$7C,$0C,$08     ; 80
        ; DB $00,$00,$38,$7C,$60,$60,$20,$00     ; 81
        ; DB $00,$00,$3C,$60,$3C,$06,$7C,$00     ; 82
        ; DB $10,$30,$3C,$30,$30,$3E,$1C,$00     ; 83
        ; DB $00,$00,$24,$66,$66,$66,$3C,$00     ; 84
        ; DB $00,$00,$24,$66,$66,$3C,$18,$00     ; 85
        ; DB $00,$00,$44,$D6,$D6,$FE,$6C,$00     ; 86
        ; DB $00,$00,$C6,$6C,$38,$6C,$C6,$00     ; 87
        ; DB $00,$00,$24,$66,$66,$3E,$06,$7C     ; 88
        ; DB $00,$00,$7E,$0C,$18,$30,$7E,$00     ; 89
        ; DB $08,$08,$08,$08,$56,$55,$57,$74     ; 90
        ; DB $18,$04,$08,$1C,$56,$55,$57,$74     ; 91
        ; DB $00,$00,$00,$00,$7E,$7E,$FF,$FF     ; 92
        ; DB $18,$3C,$18,$18,$18,$18,$7E,$FF     ; 93
        ; DB $22,$77,$7F,$7F,$3E,$1C,$08,$00     ; 94
        ; DB $3C,$7E,$ED,$FF,$7F,$2A,$54,$3C     ; 95
