


NewLine:
	lda #0		
	sta z_d			;Cursor X=0

	inc z_e			;Cursor Y++

	lda z_e
	cmp #23			;At bottom of screen?
	bcs cls			;no? return, else cls!
	rts
	
Cls:
	lda z_h
	pha
	lda z_l
	pha
		lda z_b
		pha
		lda z_c
		pha
			lda #0
			sta z_d			;x,y
			sta z_e
			sta z_l			;char,inc
			lda #$20
			sta z_h

			lda #$28		;width,height
			sta z_b
			lda #$19
			sta z_c

			jsr fillarea	;Clear the screen
		pla
		sta	z_c
		pla
		sta z_b
	pla
	sta	z_l
	pla
	sta z_h

slowdown:	;This exists for systems that run too fast
	rts


PrintNumber:		;Print Digit 0-9
	clc
	adc #48			;Ascii 0

PrintChar:			;Print char A at loc D,E
	cmp #0
	bne Notprintchar0
	inc z_d			;0=Skip this char
	rts
Notprintchar0:	
	tax
	pha
	lda z_d
	pha
	lda z_e
	pha
	lda z_h
	pha
	lda z_l
	pha
		txa
		sec
		sbc #32		;no char below 32 (Space)
		cmp #64		;Lowercase?
		bcc notlowercase
		sec
		sbc #32		;Convert to upper!
notlowercase:
;Calculate Bitmap Source
		sta z_h
		lda #0
		lsr z_h
		ror
		lsr z_h
		ror
		lsr z_h
		ror
		lsr z_h
		ror				;font * 16
		adc #<fontdata
		sta z_l
		lda z_h
		adc #>fontdata
		sta z_h
		
;Caclulate VRAM Dest
		lda z_e			;Ypos *$200
		asl 
		sta z_as
		
		lda #0
		sta z_e
		
		lda z_d
		lsr 
		ror z_e
		lsr 
		ror z_e
		lsr 
		ror z_e
		lsr 
		ror z_e			;Xpos * 16 
		
		clc
		adc z_as		;Add Ypos
		adc #$50		;Vram at $5000
		sta z_d
		
		ldy #16-1		;16 bytes per character (Two columns)
PrintCharByte:			
		lda (z_hl),y
		sta (z_de),y
		dey 
		bpl PrintCharByte
	pla
	sta	z_l
	pla
	sta z_h
	pla
	sta	z_e
	pla
	sta z_d
	pla
	inc z_d				;Xpos ++
	rts

	

ReadJoystick:	;Returnds %---FRLDU
	lda #$F0				;Set port to read (For fire button)
	sta $FE43				;SN76489 - Data Direction
	sta z_as
	
	;lda #%00000000			;Get Channel 0 - Joy 1 LR
	jsr Player_ReadControlsGetData
	lda #%00000001			;Get Channel 1 - Joy 1 UD
	jsr Player_ReadControlsGetData
		
	lda $FE40
	and #%00010000			;Get the fire button 1 (PB4 / PB5)
	ora z_as
	eor #%11101111
	rts
	
	;See page 429 of the 'BBC Microcomputer Advanced user Guide' 
	
Player_ReadControlsGetData:	;We need to convert analog to digital
	sta $FEC0						;Select channel
Player_ReadControlsDualWait:
	lda $FEC0						;Get Data
	and #%10000000
	bne Player_ReadControlsDualWait	;0= data ready
	
	lda $FEC1						;8 bit analog data
	cmp #255-32
	bcs Player_ReadControlsDualHigh	;Up/Left
	cmp #32				
	bcc Player_ReadControlsDualLow 	;Right/Down
	
	clc								;Centered
	bcc Player_ReadControlsDualB	;efective branch always
	
Player_ReadControlsDualLow:		;R/D pressed - rotate in 10
	sec
Player_ReadControlsDualB:
	rol z_as
	clc
	rol z_as
	rts
	
Player_ReadControlsDualHigh:	;U/L pressed - rotate in 01
	clc
	rol z_as
	sec
	rol z_as
	rts
	
		

fontdata:		;16 bytes per character
	ds 16 	;Space
	db $11,$10,$10,$10,$10,$00,$01,$00,$00,$88,$80,$80,$80,$00,$80,$00     ;  0
	db $22,$62,$20,$00,$00,$00,$00,$00,$88,$C8,$80,$00,$00,$00,$00,$00     ;  1
	db $00,$22,$70,$20,$25,$02,$00,$00,$00,$88,$C0,$80,$84,$08,$00,$00     ;  2
	db $11,$32,$40,$30,$10,$25,$01,$00,$88,$EA,$80,$C0,$20,$84,$08,$00     ;  3
	db $00,$C8,$C0,$10,$20,$04,$08,$00,$22,$40,$80,$00,$00,$24,$06,$00     ;  4
	db $11,$22,$20,$70,$90,$80,$07,$00,$00,$88,$80,$20,$40,$84,$02,$00     ;  5
	db $00,$10,$30,$00,$00,$00,$00,$00,$CC,$C8,$00,$00,$00,$00,$00,$00     ;  6
	db $11,$10,$30,$30,$30,$01,$01,$00,$88,$88,$00,$00,$00,$80,$08,$00     ;  7
	db $11,$10,$00,$00,$00,$01,$01,$00,$88,$88,$C0,$C0,$C0,$80,$08,$00     ;  8
	db $00,$44,$20,$10,$10,$20,$04,$00,$88,$91,$A0,$C0,$40,$20,$01,$00     ;  9
	db $00,$10,$10,$70,$10,$01,$00,$00,$00,$88,$80,$E0,$80,$80,$00,$00     ; 10
	db $00,$00,$00,$00,$00,$01,$01,$03,$00,$00,$00,$00,$00,$80,$08,$00     ; 11
	db $00,$00,$00,$70,$07,$00,$00,$00,$00,$00,$00,$E0,$0E,$00,$00,$00     ; 12
	db $00,$00,$00,$00,$00,$01,$01,$00,$00,$00,$00,$00,$00,$80,$08,$00     ; 13
	db $00,$00,$00,$10,$20,$04,$08,$00,$22,$40,$80,$00,$00,$00,$00,$00     ; 14
	db $77,$C8,$D0,$D0,$49,$0C,$07,$00,$CC,$62,$60,$60,$42,$06,$0C,$00     ; 15
	db $11,$10,$10,$10,$10,$01,$00,$00,$00,$88,$80,$80,$80,$80,$08,$00     ; 16
	db $33,$72,$00,$30,$60,$25,$03,$00,$CC,$EA,$60,$C0,$00,$A4,$0C,$00     ; 17
	db $33,$72,$00,$10,$00,$25,$03,$00,$CC,$EA,$60,$C0,$60,$A4,$0C,$00     ; 18
	db $11,$32,$60,$C0,$70,$00,$00,$00,$88,$C8,$40,$C0,$C0,$84,$08,$00     ; 19
	db $33,$72,$60,$70,$00,$25,$03,$00,$CC,$EA,$00,$C0,$60,$A4,$0E,$00     ; 20
	db $33,$72,$60,$70,$60,$24,$03,$00,$CC,$EA,$00,$C0,$60,$24,$0C,$00     ; 21
	db $33,$72,$00,$00,$10,$01,$01,$00,$CC,$EA,$60,$C0,$80,$80,$00,$00     ; 22
	db $33,$62,$60,$30,$60,$24,$03,$00,$CC,$62,$60,$C0,$60,$24,$0C,$00     ; 23
	db $33,$62,$60,$30,$00,$25,$03,$00,$CC,$62,$60,$E0,$60,$A4,$0C,$00     ; 24
	db $00,$00,$11,$10,$00,$01,$01,$00,$00,$00,$88,$80,$00,$80,$08,$00     ; 25
	db $00,$00,$11,$10,$00,$01,$01,$03,$00,$00,$88,$80,$00,$80,$08,$00     ; 26
	db $00,$10,$30,$60,$30,$01,$00,$00,$CC,$C8,$80,$00,$80,$84,$0C,$00     ; 27
	db $00,$00,$72,$00,$00,$25,$00,$00,$00,$00,$EA,$00,$00,$A4,$00,$00     ; 28
	db $66,$72,$30,$00,$30,$25,$06,$00,$00,$00,$80,$C0,$80,$00,$00,$00     ; 29
	db $33,$72,$00,$10,$00,$10,$01,$00,$CC,$62,$60,$C0,$00,$08,$08,$00     ; 30
	db $77,$C8,$A0,$B0,$C0,$A5,$07,$00,$CC,$E2,$60,$60,$42,$00,$0C,$00     ; 31
	db $11,$32,$60,$60,$70,$24,$02,$00,$88,$C8,$60,$60,$E0,$24,$04,$00     ; 32
	db $33,$62,$60,$70,$60,$24,$03,$00,$CC,$62,$60,$C0,$60,$24,$0C,$00     ; 33
	db $33,$72,$C0,$C0,$C0,$25,$03,$00,$88,$C8,$00,$00,$00,$84,$08,$00     ; 34
	db $33,$62,$60,$60,$60,$24,$03,$00,$CC,$40,$60,$60,$60,$04,$08,$00     ; 35
	db $33,$72,$60,$70,$60,$25,$03,$00,$CC,$EA,$00,$80,$00,$A4,$0C,$00     ; 36
	db $33,$72,$60,$70,$60,$24,$02,$00,$88,$C8,$00,$80,$00,$00,$00,$00     ; 37
	db $33,$62,$C0,$C0,$C0,$24,$03,$00,$CC,$62,$00,$00,$C0,$24,$0C,$00     ; 38
	db $22,$62,$60,$70,$60,$24,$02,$00,$44,$62,$60,$E0,$60,$24,$04,$00     ; 39
	db $11,$10,$10,$10,$10,$01,$00,$00,$00,$88,$80,$80,$80,$80,$08,$00     ; 40
	db $00,$00,$00,$00,$40,$A5,$07,$00,$88,$C8,$C0,$C0,$C0,$84,$08,$00     ; 41
	db $22,$62,$60,$70,$60,$24,$02,$00,$44,$62,$C0,$80,$C0,$24,$04,$00     ; 42
	db $22,$62,$60,$60,$60,$25,$03,$00,$00,$00,$00,$00,$00,$A4,$0E,$00     ; 43
	db $44,$EA,$F0,$D0,$D0,$94,$04,$00,$44,$EA,$E0,$60,$60,$24,$04,$00     ; 44
	db $44,$EA,$F0,$D0,$C0,$84,$04,$00,$44,$62,$60,$E0,$E0,$24,$04,$00     ; 45
	db $33,$62,$C0,$C0,$C0,$24,$03,$00,$88,$C8,$60,$60,$60,$84,$08,$00     ; 46
	db $33,$62,$60,$70,$60,$24,$02,$00,$88,$C0,$40,$C0,$00,$00,$00,$00     ; 47
	db $33,$62,$C0,$C0,$C0,$07,$03,$00,$88,$C8,$60,$60,$A0,$04,$0A,$00     ; 48
	db $33,$62,$60,$70,$60,$24,$02,$00,$CC,$62,$60,$C0,$C0,$24,$06,$00     ; 49
	db $33,$72,$60,$30,$00,$25,$03,$00,$CC,$E2,$00,$C0,$60,$A4,$0C,$00     ; 50
	db $33,$72,$10,$10,$10,$01,$00,$00,$CC,$EA,$80,$80,$80,$80,$08,$00     ; 51
	db $22,$62,$60,$60,$60,$24,$03,$00,$44,$62,$60,$60,$60,$24,$0C,$00     ; 52
	db $22,$62,$60,$60,$60,$21,$01,$00,$44,$62,$60,$60,$60,$84,$08,$00     ; 53
	db $44,$C8,$D0,$D0,$F0,$4A,$04,$00,$44,$62,$60,$60,$E0,$4A,$04,$00     ; 54
	db $CC,$62,$30,$30,$60,$84,$04,$00,$66,$C8,$80,$80,$C0,$24,$04,$00     ; 55
	db $22,$62,$60,$30,$10,$01,$00,$00,$44,$62,$60,$C0,$80,$80,$08,$00     ; 56
	db $77,$FA,$00,$10,$30,$25,$07,$00,$CC,$C8,$C0,$80,$00,$A4,$0C,$00     ; 57
	db $11,$32,$30,$30,$30,$21,$01,$00,$CC,$00,$00,$00,$00,$00,$0C,$00     ; 58
	db $88,$40,$20,$10,$00,$00,$00,$00,$00,$00,$00,$00,$80,$04,$02,$00     ; 59
	db $33,$00,$00,$00,$00,$00,$03,$00,$88,$C8,$C0,$C0,$C0,$84,$08,$00     ; 60
	db $11,$32,$70,$10,$10,$01,$01,$00,$88,$C8,$E0,$80,$80,$80,$08,$00     ; 61
	db $00,$00,$00,$00,$00,$00,$0F,$0F,$00,$00,$00,$00,$00,$00,$0F,$0F     ; 62
	db $33,$10,$00,$00,$00,$00,$00,$00,$00,$88,$C0,$00,$00,$00,$00,$00     ; 63


	
CRTCConfig: ;Define a 256 x 192 screen 
	db $7F		;0 - Horizontal total
	db $40		;1 - Horizontal displayed characters
	db $5A		;2 - Horizontal sync position
	db $28		;3 - Horizontal sync width/Vertical sync time
	db $26			;4 - Vertical total
	db $00			;5 - Vertical total adjust
	db 24			;6 - Vertical displayed characters (25)
	db 31			;7 - Vertical sync position
	db $01			;8 - Interlace/Display delay/Cursor delay
	db $07			;9 - Scan lines per character
	db %00110000	;10 - Cursor start line and blink type
	db $0			;11 - Cursor end line
	db $0A		;12 - Screen start address H (Address /8)
	db $00		;13 - Screen start address L 

ULAConfig:	
;		SC  SC		-	S=Screen C=Color
	db $07,$17	;0 - 7=Black
	db $47,$57	;0
	db $22,$32		;1 2=Magenta
	db $62,$72		;1
	db $81,$91			;2	1=Cyan
	db $C1,$D1			;2
	db $A0,$B0				;3 0=White
	db $E0,$F0				;3
	
;EOR True   Color
;7  (0) 	black
;6  (1) 	red
;5  (2) 	green
;4  (3) 	yellow (green—red)
;3  (4) 	blue
;2  (5) 	magenta (red—blue)
;1  (6) 	cyan (green—blue)
;0  (7) 	white


BBCLastByte:; db 0