

ramarea equ $200	;Define some space for program vars
						;First 16 bytes reserved for core.

z_Regs equ $30		;Used for fake Z80 register pairs


	ORG $0C00		;Program Start
	
	sei 			;Disable interrupts
	
;Set up bitmap Screen
	
	lda $C050 		;TXTCLR:   Display Graphics
	lda $C052 		;MIXCLR:   Display Full Screen
	lda $c057 		;HIRES:    Display HiRes Graphics
	lda $C055 		;TXTPAGE2: If 80STORE Off: Display Page 2
	
;Clear the screen 
	
	lda #$40		;set z_HL to $4000 (VRAM)
	sta z_h
	lda #0
	sta z_l
	
	tay
	ldx #$20		;Clear $2000 bytes of VRAM
InitClearVram:		; (CLS only clears the virtual screen)
	lda #0
	sta (z_hl),y
	iny
	bne InitClearVram
	inc z_h
	dex
	bne InitClearVram
	

	jsr ClearRam	;Clear the RamArea
	
	
	