

		
newline:
	lda #0	
	sta z_d		;Xpos=0

	inc z_e		;Ypos++

	lda z_e
	cmp #23		;At bottom of screen?
	bcs cls		;no? return, else cls!
	rts

Cls:
	lda z_h
	pha
	lda z_l
	pha
	lda z_b
	pha
	lda z_c
	pha
		lda #0
		sta z_d			;x,y
		sta z_e
		sta z_l			;char,inc
		lda #$20
		sta z_h

		lda #40			;width,height
		sta z_b
		lda #$19
		sta z_c

		jsr fillarea	;Clear the screen
	pla
	sta	z_c
	pla
	sta z_b
	pla
	sta	z_l
	pla
	sta z_h

slowdown:	;this exists for systems that run too fast
	rts


printnumber:		
	clc
	adc #48			;ascii 0

printchar:			;print char A at loc D,E
	cmp #0
	bne Notprintchar0
	inc z_d			;if CHR=0 Xpos++
	rts
	
Notprintchar0:	
	tay
	pha
	lda z_d
	pha
	lda z_e
	pha
	lda z_h
	pha
	lda z_l
	pha
	
;Calculate VRAM Dest
		lda #0
		sta z_l
		lda z_e				;Ypos
		asl
		asl
		asl					;8 lines per character
		
		tax 				;--BBB---	;Multiply by $0080
			and #%00111000
			lsr
			lsr
			lsr					
			lsr				;Shift 1 bit right 
			ror z_l
			adc #$40		;Screen base $4000
			sta z_h
		txa					;AA------		;multiply by $0028
		rol 				;Get 1st A from AA------ 
		bcc GetScreenPos_SecondThird
		
GetScreenPos_ThirdThird:
		lda z_l
		clc
		adc #$50			;3/3 = Add $0050 to address
		jmp GetScreenPos_ThirdDone
		
GetScreenPos_SecondThird:
		rol 				;Get 2nd A from AA------ 
		bcc GetScreenPos_FirstThird
		lda z_l
		clc
		adc #$28			;2/3 = Add $0028 to address
		
GetScreenPos_ThirdDone:	
		sta z_l
		
GetScreenPos_FirstThird:	;1/3 = Add nothing to addreess
		lda z_d				;Xpos
		clc
		adc #4
		adc z_l				;Add X to calculated address
		sta z_l
		
;Calcuate source Font
		lda #0
		sta z_d
		
		tya
		sec
		sbc #32			;no char below 32
		cmp #64			;Lower case?
		bcc notlowercase
		sec				;Yes?
		sbc #32			;Convert to upper!
notlowercase:
		asl
		rol z_d
		asl
		rol z_d
		asl
		rol z_d			;8 bytes per char
		
		adc #<fontdata
		sta z_e
		lda z_d
		adc #>fontdata	;Add font base
		sta z_d
		
		ldx #0
		ldy #0
PrintCharByte:			
		lda (z_de),y
		sta (z_hl,x)
		
		lda z_H			;Down $0400 (1 line)
		add #4
		sta z_H
			
		iny
		cpy	#8
		bne PrintCharByte

	pla
	sta	z_l
	pla
	sta z_h
	pla
	sta	z_e
	pla
	sta z_d
	pla
	inc z_d		;Xpos ++
	rts

	
	
;Apple Joysticks are annoying!
;they are analog... we have to strobe the port 
;then read from the X and Y ports, and count up until the top bit changes
;this is a 'timer'...using just 1 bit (the top one) 
;it effectively returns an 'analog' value from about 0-100
	
ReadJoystick:	;Returns %---FRLDU
	lda #0
	tay
	tax
	stx z_as			;Buildup byte
	
	lda $C061			;Fire 1
	rol					;Move in the fire button
	rol z_as
	
	lda $C070			;Strobe Joypads
	
Joy_ReadAgain:
	pha
	pla					;delay
Joy_gotPDL1:			;Jump backhere when we get X
Joy_ChkPDl0:
	lda	$C064 			;Y axis
	bpl Joy_gotPDL0		;Have we got Y?
	nop
	iny	
	lda $C065			;X axis
	bmi Joy_nogots		;Have we got X?
	bpl Joy_gotPDL1
	
Joy_nogots:
	inx
	jmp Joy_ChkPdl0
Joy_gotPDL0:			;We've Got Ypos - just waiting for X
	lda  $C065			;X Axis
	bmi Joy_Nogots
	
	tya
	jsr JoyConvertAnalog	;Convert Y
	txa
	jsr JoyConvertAnalog	;Convert Y
	
	lda z_as
	eor #%11111111			;Flip bits of result
	rts
	
JoyConvertAnalog:	;covert analog from 0-100 into L/R or U/D
	cmp #$66
	bcs Joy_Rbit	;>$66?  %10
	cmp #$33
	bcc Joy_Lbit	;<$33?  %01
	clc 
	bcc Joy_Cbit	;Center %00
Joy_Rbit:
	sec 
Joy_Cbit:
	rol z_as
	clc
	rol z_as
	rts
	
Joy_Lbit:
	clc
	rol z_as
	sec 
	rol z_as
	rts
	
	
FontData:	;8 bytes per char
		db 0,0,0,0,0,0,0,0		;Space
	    DB $08,$08,$08,$08,$08,$00,$08,$00     ;  0
        DB $04,$16,$04,$00,$00,$00,$00,$00     ;  1
        DB $00,$04,$1E,$04,$1E,$04,$00,$00     ;  2
        DB $08,$3C,$02,$1C,$28,$1E,$08,$00     ;  3
        DB $20,$13,$03,$08,$04,$32,$31,$00     ;  4
        DB $08,$04,$04,$2E,$19,$11,$2E,$00     ;  5
        DB $10,$18,$0C,$00,$00,$00,$00,$00     ;  6
        DB $08,$08,$0C,$0C,$0C,$08,$08,$00     ;  7
        DB $08,$08,$10,$10,$10,$08,$08,$00     ;  8
        DB $00,$42,$24,$18,$18,$24,$42,$00     ;  9
        DB $00,$08,$08,$3E,$08,$08,$00,$00     ; 10
        DB $00,$00,$00,$00,$00,$08,$08,$0C     ; 11
        DB $00,$00,$00,$3E,$3E,$00,$00,$00     ; 12
        DB $00,$00,$00,$00,$00,$08,$08,$00     ; 13
        DB $20,$10,$00,$08,$04,$02,$01,$00     ; 14
        DB $1E,$33,$3B,$3B,$3B,$33,$1E,$00     ; 15
        DB $08,$08,$08,$08,$08,$08,$00,$00     ; 16
        DB $1C,$3E,$30,$1C,$06,$3E,$1C,$00     ; 17
        DB $1C,$3E,$30,$18,$30,$3E,$1C,$00     ; 18
        DB $08,$1C,$16,$13,$1E,$10,$00,$00     ; 19
        DB $1C,$3E,$06,$1E,$30,$3E,$3C,$00     ; 20
        DB $1C,$3E,$06,$1E,$36,$36,$1C,$00     ; 21
        DB $1C,$3E,$30,$10,$08,$08,$08,$00     ; 22
        DB $1C,$36,$36,$1C,$36,$36,$1C,$00     ; 23
        DB $1C,$36,$36,$3C,$30,$3E,$1C,$00     ; 24
        DB $00,$00,$08,$08,$00,$08,$08,$00     ; 25
        DB $00,$00,$08,$08,$00,$08,$08,$0C     ; 26
        DB $10,$18,$0C,$06,$0C,$18,$10,$00     ; 27
        DB $00,$00,$3E,$00,$00,$3E,$00,$00     ; 28
        DB $06,$0E,$0C,$10,$0C,$0E,$06,$00     ; 29
        DB $1C,$3E,$30,$18,$00,$08,$08,$00     ; 30
        DB $1E,$33,$35,$3D,$33,$0F,$1E,$00     ; 31
        DB $08,$1C,$36,$36,$3E,$36,$14,$00     ; 32
        DB $1C,$36,$36,$1E,$36,$36,$1C,$00     ; 33
        DB $0C,$1E,$03,$03,$03,$1E,$0C,$00     ; 34
        DB $1C,$16,$36,$36,$36,$16,$0C,$00     ; 35
        DB $1C,$3E,$06,$0E,$06,$3E,$1C,$00     ; 36
        DB $0C,$1E,$06,$0E,$06,$06,$04,$00     ; 37
        DB $1C,$36,$03,$03,$13,$36,$1C,$00     ; 38
        DB $14,$36,$36,$3E,$36,$36,$14,$00     ; 39
        DB $08,$08,$08,$08,$08,$08,$00,$00     ; 40
        DB $00,$10,$10,$10,$12,$1F,$0E,$00     ; 41
        DB $14,$36,$16,$0E,$16,$36,$14,$00     ; 42
        DB $04,$06,$06,$06,$06,$3E,$3C,$00     ; 43
        DB $12,$37,$3F,$3B,$3B,$3B,$12,$00     ; 44
        DB $12,$37,$3F,$3B,$33,$33,$12,$00     ; 45
        DB $0C,$16,$33,$33,$33,$16,$0C,$00     ; 46
        DB $0C,$16,$16,$1E,$06,$06,$04,$00     ; 47
        DB $0C,$16,$33,$33,$23,$1E,$2C,$00     ; 48
        DB $1C,$36,$36,$1E,$16,$36,$34,$00     ; 49
        DB $1C,$3E,$06,$1C,$30,$3E,$1C,$00     ; 50
        DB $1C,$3E,$08,$08,$08,$08,$00,$00     ; 51
        DB $14,$36,$36,$36,$36,$36,$1C,$00     ; 52
        DB $14,$36,$36,$36,$36,$1C,$08,$00     ; 53
        DB $12,$33,$3B,$3B,$3F,$37,$12,$00     ; 54
        DB $33,$16,$0C,$0C,$16,$33,$12,$00     ; 55
        DB $14,$36,$36,$1C,$08,$08,$00,$00     ; 56
        DB $1E,$1F,$10,$08,$0C,$3E,$1E,$00     ; 57
        DB $18,$0C,$0C,$0C,$0C,$0C,$18,$00     ; 58
        DB $01,$02,$04,$08,$00,$10,$20,$00     ; 59
        DB $0C,$10,$10,$10,$10,$10,$0C,$00     ; 60
        DB $08,$1C,$3E,$08,$08,$08,$08,$00     ; 61
        DB $00,$00,$00,$00,$00,$00,$7F,$7F     ; 62
        DB $0C,$08,$10,$00,$00,$00,$00,$00     ; 63
        ; DB $00,$00,$0C,$10,$1E,$13,$0E,$00     ; 64
        ; DB $04,$06,$1E,$36,$36,$36,$1C,$00     ; 65
        ; DB $00,$00,$1C,$36,$06,$36,$1C,$00     ; 66
        ; DB $00,$10,$1E,$13,$13,$13,$0E,$00     ; 67
        ; DB $00,$00,$1C,$36,$3E,$06,$1C,$00     ; 68
        ; DB $18,$3C,$0C,$0C,$0C,$0C,$08,$00     ; 69
        ; DB $00,$00,$1C,$36,$36,$3C,$30,$1C     ; 70
        ; DB $04,$06,$16,$3E,$36,$36,$14,$00     ; 71
        ; DB $08,$00,$08,$08,$08,$08,$00,$00     ; 72
        ; DB $30,$00,$10,$30,$30,$34,$36,$1C     ; 73
        ; DB $04,$06,$36,$16,$0E,$16,$34,$00     ; 74
        ; DB $08,$08,$08,$08,$08,$08,$00,$00     ; 75
        ; DB $00,$00,$16,$3F,$3B,$3B,$33,$00     ; 76
        ; DB $00,$00,$1C,$36,$36,$36,$14,$00     ; 77
        ; DB $00,$00,$1C,$36,$36,$36,$1C,$00     ; 78
        ; DB $00,$00,$1C,$36,$36,$1E,$06,$04     ; 79
        ; DB $00,$00,$0E,$13,$13,$1E,$10,$00     ; 80
        ; DB $00,$00,$0C,$1E,$06,$06,$04,$00     ; 81
        ; DB $00,$00,$1C,$06,$1C,$30,$1E,$00     ; 82
        ; DB $08,$0C,$1C,$0C,$0C,$3C,$18,$00     ; 83
        ; DB $00,$00,$14,$36,$36,$36,$1C,$00     ; 84
        ; DB $00,$00,$14,$36,$36,$1C,$08,$00     ; 85
        ; DB $00,$00,$12,$3B,$3B,$3F,$16,$00     ; 86
        ; DB $00,$00,$33,$16,$0C,$16,$33,$00     ; 87
        ; DB $00,$00,$14,$36,$36,$3C,$30,$1E     ; 88
        ; DB $00,$00,$3E,$10,$08,$0C,$3E,$00     ; 89
        ; DB $00,$00,$00,$00,$3A,$5A,$7A,$1E     ; 90
        ; DB $08,$10,$00,$18,$3A,$5A,$7A,$1E     ; 91
        ; DB $00,$00,$00,$00,$3E,$3E,$7F,$7F     ; 92
        ; DB $08,$1C,$08,$08,$08,$08,$3E,$7F     ; 93
        ; DB $24,$7E,$7E,$7E,$3C,$18,$00,$00     ; 94
        ; DB $1C,$3E,$57,$7F,$7E,$24,$1A,$1C     ; 95
        ; DB $08,$08,$08,$08,$3E,$3E,$08,$08     ; 96
        ; DB $08,$08,$08,$08,$1C,$1C,$08,$08     ; 97
        ; DB $08,$08,$08,$08,$08,$08,$08,$08     ; 98
        ; DB $3C,$6A,$43,$7F,$5F,$63,$37,$1D     ; 99
        ; DB $00,$00,$00,$00,$00,$00,$00,$00     ;100
     