
ramarea equ $200	;Define some space for program vars
						;First 16 bytes reserved for core.

z_Regs equ $20		;Used for fake Z80 register pairs
	
	
;Addresses of certain hardware is different on the A5200 and A800
	
	ifdef BuildA80		;Atari 800 settings
	
GTIA equ $D000			;GTIA address
PIA  equ $D300			;PIA address
;ChrAddrH equ $E0    	;Font at $E000

	org $A000     	  	;Start of cartridge area (Atari 800)
	
	else				;Atari 5200 settings
	
GTIA  equ $C000			;GTIA address
POKEY equ $E800			;POKEY address
;ChrAddrH equ $F8    	;Font at $F800

	org $4000       	;Start of cartridge area (Atari 5200)
	
	endif
	

ProgramStart:        
	sei                 ;Disable interrupts

;Reset the GTIA 

    ldx #$00
    txa
ClearLoop    
    sta $00,x           ;Clear zero page
    sta GTIA,x          ;Clear GTIA
    dex
    bne ClearLoop
			
;Define the Display list and turn on the screen
	
	lda #<DisplayList
	sta $D402 			;DLISTL - Display list lo
	lda #>DisplayList
	sta $D403 			;DLISTH - Display list hi
	
	;lda #ChrAddrH
	;sta $D409 			;CHBASE - Character set base
						; (Not used, we have our own!)
	lda #%00100010   	
	sta $D400 			;DMACTL - DMA Control (screen on)


;Define the colors

	ifdef A52_FourColor
		lda #$98      	;Set color PF1 (foreground) (CYAN)
		sta GTIA+ $17 	;COLPF1 equ 
		
		lda #$0F       	;Set color PF2 (background) (White)
		sta GTIA+ $18	;COLPF2 

		lda #$68        ;Set color PF0 (Purple)
		sta GTIA+ $16
		
		lda #$00       ;Set color PF0 (Black)
		sta GTIA+ $1A
	else
		lda #$0F      	  	;Set color PF1 (foreground)
		sta GTIA+ $17 		;COLPF1 equ 
	
		lda #$00       	 	;Set color PF2 (background)
		sta GTIA+ $18		;COLPF2 
	endif
	
	
	jsr ClearRam		;Clear first 256 bytes of ram, and CLS
	