


		
newline:
	lda #0		;new line
	sta z_d

	inc z_e

	lda z_e
	cmp #23			;at bottom of screen?
	bcs cls			;no? return, else cls!
	rts

cls:
	lda z_h
	pha
	lda z_l
	pha
	lda z_b
	pha
	lda z_c
	pha
		lda #0
		sta z_d			;x,y
		sta z_e
		sta z_l			;char,inc
		lda #$20
		sta z_h

		lda #28		;width,height
		sta z_b
		lda #$19
		sta z_c

		jsr fillarea
	pla
	sta	z_c
	pla
	sta z_b
	
	pla
	sta	z_l
	pla
	sta z_h
	
slowdown:	;this exists for systems that run too fast
	rts

printnumber:		
	clc
	adc #48			;ascii 0

printchar:			;print char A at loc D,E
	cmp #0
	bne Notprintchar0
;printchar0:
	inc z_d			;Xpos ++
	rts
	
Notprintchar0:	
	tay
	pha
	lda z_d
	pha
	lda z_e
	pha	
	lda z_h
	pha
	lda z_l
	pha
		
;Get VRAM Dest
		lda z_e			;Effectively Yline*32
		sta z_h			;Update High Byte
	
		lda #0			;40 bytes per Yline =Line*32+8
		tax
		lsr z_e			;Shift 2 bits
		ror 			;%0000YYYY YYYY0000
		lsr z_e
		ror 			;%00000YYY YYYYY000 = Yline*8 
		
		
		adc z_d			;Update Low Byte (Xpos)
		sta z_l
			
		lda z_e			;Add to Update High Byte
		adc z_h
		sta z_h	

		clc
		lda z_l
		adc #$60+4		;+4 to center virtual screen
		sta z_l
		lda z_h			;Add Screen Base ($2060)
		adc #$20
		sta z_h		
		
;Get Source Bitmap (character)
		stx z_d
		
		tya				;Char num
		sec
		sbc #32			;no char below 32
		cmp #64
		bcc notlowercase
		sec
		sbc #32		;we don't define lowercase, convert to upper!
notlowercase:
		asl
		rol z_d			;8 bytes per character
		asl
		rol z_d
		asl
		rol z_d
		
		adc #<fontdata	;Add bitmap base
		sta z_e
		lda z_d
		adc #>fontdata
		sta z_d
		
;Transfer Bitmap
		ldy #0
		;ldx #0
PrintCharByte:			
		lda (z_de),y	;Get A byte
		sta (z_hl,x)	;Write to screen
		
		lda z_l
		clc
		adc #40		;Down a line +$0040
		sta z_l
		bcc PrintCharByte_HOK
		inc z_h
	PrintCharByte_HOK:	
		iny
		cpy #8
		bne PrintCharByte
	pla
	sta	z_l
	pla
	sta z_h
	pla
	sta	z_e
	pla
	sta z_d
	pla
	
	inc z_d			;Xpos ++
	rts

	
	
	ifdef BuildA80	
ReadJoystick:		;We Return %---FRLDU
		lda PIA+$0		;22221111 - RLDU in player controls
		and #%00001111	;Bottom Nibble is Player 1 Joystick
		ora #%11100000
		sta z_as

		lda GTIA+$10	;$D010 - TRIG0 - joystick trigger 0
		clc
		rol
		rol
		rol
		rol				;%---F----
		ora z_as		;Joystick 1 Done
		rts
	endif
	
	
	ifdef BuildA52		;Atari 5200 doesn't have PIA 
ReadJoystick:		;We Return %---FRLDU
		lda GTIA+$10		;$C010 - TRIG0 - joystick trigger 0
		sta z_as
		
		lda pokey+0			;$E800 - POT0 - game paddle 0
		jsr Player_ReadControlsProcessAnalog
		
		lda pokey+1			;$E801 - POT1 - game paddle 1
		jsr Player_ReadControlsProcessAnalog
		
		lda #%11100000		;Unused bits.
		ora z_as
		rts
		
		;Convert Analog to Digital
Player_ReadControlsProcessAnalog:
		cmp #255-64
		bcs Player_ReadControlsProcessHigh	;Up/Left
		cmp #64
		bcc Player_ReadControlsProcessLow	;Right/Down
											
		sec									;Centered
		bcs Player_ReadControlsProcessB		;efective branch always

Player_ReadControlsProcessHigh:		;U/L pressed - rotate in 01
		clc
Player_ReadControlsProcessB:
		rol z_as
		sec
		rol z_as
		rts
Player_ReadControlsProcessLow:		;R/D pressed - rotate in 10
		sec
		rol z_as
		clc
		rol z_as
		rts
	endif

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


FontData:											
		db 0,0,0,0,0,0,0,0	;Space
	    DB $10,$18,$18,$18,$18,$00,$18,$00     ;  0
        DB $28,$6C,$28,$00,$00,$00,$00,$00     ;  1
        DB $00,$28,$7C,$28,$7C,$28,$00,$00     ;  2
        DB $18,$3E,$48,$3C,$12,$7C,$18,$00     ;  3
        DB $02,$C4,$C8,$10,$20,$46,$86,$00     ;  4
        DB $10,$28,$28,$72,$94,$8C,$72,$00     ;  5
        DB $0C,$1C,$30,$00,$00,$00,$00,$00     ;  6
        DB $18,$18,$30,$30,$30,$18,$18,$00     ;  7
        DB $18,$18,$0C,$0C,$0C,$18,$18,$00     ;  8
        DB $08,$49,$2A,$1C,$14,$22,$41,$00     ;  9
        DB $00,$18,$18,$7E,$18,$18,$00,$00     ; 10
        DB $00,$00,$00,$00,$00,$18,$18,$30     ; 11
        DB $00,$00,$00,$7E,$7E,$00,$00,$00     ; 12
        DB $00,$00,$00,$00,$00,$18,$18,$00     ; 13
        DB $02,$04,$08,$10,$20,$40,$80,$00     ; 14
        DB $7C,$C6,$D6,$D6,$D6,$C6,$7C,$00     ; 15
        DB $10,$18,$18,$18,$18,$18,$08,$00     ; 16
        DB $3C,$7E,$06,$3C,$60,$7E,$3C,$00     ; 17
        DB $3C,$7E,$06,$1C,$06,$7E,$3C,$00     ; 18
        DB $18,$3C,$64,$CC,$7C,$0C,$08,$00     ; 19
        DB $3C,$7E,$60,$7C,$06,$7E,$3E,$00     ; 20
        DB $3C,$7E,$60,$7C,$66,$66,$3C,$00     ; 21
        DB $3C,$7E,$06,$0C,$18,$18,$10,$00     ; 22
        DB $3C,$66,$66,$3C,$66,$66,$3C,$00     ; 23
        DB $3C,$66,$66,$3E,$06,$7E,$3C,$00     ; 24
        DB $00,$00,$18,$18,$00,$18,$18,$00     ; 25
        DB $00,$00,$18,$18,$00,$18,$18,$30     ; 26
        DB $0C,$1C,$38,$60,$38,$1C,$0C,$00     ; 27
        DB $00,$00,$7E,$00,$00,$7E,$00,$00     ; 28
        DB $60,$70,$38,$0C,$38,$70,$60,$00     ; 29
        DB $3C,$76,$06,$1C,$00,$18,$18,$00     ; 30
        DB $7C,$CE,$A6,$B6,$C6,$F0,$7C,$00     ; 31
        DB $18,$3C,$66,$66,$7E,$66,$24,$00     ; 32
        DB $3C,$66,$66,$7C,$66,$66,$3C,$00     ; 33
        DB $38,$7C,$C0,$C0,$C0,$7C,$38,$00     ; 34
        DB $3C,$64,$66,$66,$66,$64,$38,$00     ; 35
        DB $3C,$7E,$60,$78,$60,$7E,$3C,$00     ; 36
        DB $38,$7C,$60,$78,$60,$60,$20,$00     ; 37
        DB $3C,$66,$C0,$C0,$CC,$66,$3C,$00     ; 38
        DB $24,$66,$66,$7E,$66,$66,$24,$00     ; 39
        DB $10,$18,$18,$18,$18,$18,$08,$00     ; 40
        DB $08,$0C,$0C,$0C,$4C,$FC,$78,$00     ; 41
        DB $24,$66,$6C,$78,$6C,$66,$24,$00     ; 42
        DB $20,$60,$60,$60,$60,$7E,$3E,$00     ; 43
        DB $44,$EE,$FE,$D6,$D6,$D6,$44,$00     ; 44
        DB $44,$E6,$F6,$DE,$CE,$C6,$44,$00     ; 45
        DB $38,$6C,$C6,$C6,$C6,$6C,$38,$00     ; 46
        DB $38,$6C,$64,$7C,$60,$60,$20,$00     ; 47
        DB $38,$6C,$C6,$C6,$CA,$74,$3A,$00     ; 48
        DB $3C,$66,$66,$7C,$6C,$66,$26,$00     ; 49
        DB $3C,$7E,$60,$3C,$06,$7E,$3C,$00     ; 50
        DB $3C,$7E,$18,$18,$18,$18,$08,$00     ; 51
        DB $24,$66,$66,$66,$66,$66,$3C,$00     ; 52
        DB $24,$66,$66,$66,$66,$3C,$18,$00     ; 53
        DB $44,$C6,$D6,$D6,$FE,$EE,$44,$00     ; 54
        DB $C6,$6C,$38,$38,$6C,$C6,$44,$00     ; 55
        DB $24,$66,$66,$3C,$18,$18,$08,$00     ; 56
        DB $7C,$FC,$0C,$18,$30,$7E,$7C,$00     ; 57
        DB $1C,$30,$30,$30,$30,$30,$1C,$00     ; 58
        DB $80,$40,$20,$10,$08,$04,$02,$00     ; 59
        DB $38,$0C,$0C,$0C,$0C,$0C,$38,$00     ; 60
        DB $18,$3C,$7E,$18,$18,$18,$18,$00     ; 61
        DB $00,$00,$00,$00,$00,$00,$FF,$FF     ; 62
        DB $30,$18,$0C,$00,$00,$00,$00,$00     ; 63
	


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Display List
  
    org $bf20
	ifdef A52_FourColor	
Smode Equ $0E	;E=4 color.... F=2 color
	else
Smode Equ $0F	;E=4 color.... F=2 color
	endif

DisplayList:				;Display list data
	db $70,$70,$70;$70 7= 8 blank lines 0= blank lines

		db $40+Smode,$60,$20	;Strange start ($2060) to safely step over the boundary
		
		db	         Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		
		db $40+Smode,$00,$30	;Have to manually step over the 4k boundary ($3000)
		db	         Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		
	db $41					;Loop
	dw DisplayList
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Rom Footer
        org $bffd
        db $FF         ;Disable Atari Logo
        dw ProgramStart;program Start
		
		
		
		
		