

Xpos equ $80		;Player pos
Ypos equ $81

    ORG $F000       ;Start of program cartridge
ProgStart:

	lda #$80
	sta $9			;Playfield back

	lda #1			;Set  start player XY
	sta Xpos
	lda #0
	sta Ypos
	
	    ;%--MMPPP	;Missile/Player
	lda #%0000000	;0/5/7 size ... 1/2/4 dbl ... 3/6 triple
	sta $04			;NUSIZ0: number-size player-missile 0 
	
	
DoFrame:
    lda #%00000010  ;Start vsync
    sta $00			 ;vsync
    	
    sta $02 		;wsync - 3 lines
	sta $02 		;wsync
	sta $02 		;wsync
	
    lda #0			;End Vsync
    sta $00 		;vsync

	lda #43			;76 ticks per line *37 lines /64 ticks per timer
	sta $296
	
	jsr DoGameTasks	;Update Sprite pos.
	
	jsr WaitTimer	;Wait for the timer to end
    
	lda #0          ;End vblank
	sta $01 		;vblank

	
	ldy #0			;Scanline 	(0-191)
	ldx #0			;Spriteline (0-15)
	
DoScanLine:
	lda #%00001000	;Test pattern (out of sprite area)
	
	cpy Ypos		;Raster before sprite?
	bcc SetSprite
	cpx #16			;Sprite height. 
	bcs SetSprite	;Drawn all sprite lines? Yes? then skip!
	
	lda MySprite,X	;Get a sprite line
	
	inx
SetSprite:	
	sta $02			;wsync
	sta $1B 		;GRP0: set Sprite pixels (graphics player 0)
	
	
    iny        
    cpy #191		;Done all lines?
    bcc DoScanLine

	
;Overscan
	lda #35			;76 ticks per line *30 lines /64 ticks per timer
	sta $296
	
	lda #%01000010  ;Start Vblank
    sta $01 		;vblank
	
	jsr WaitTimer	
	
    jmp DoFrame		;Repeat
	
	
	
	

	
DoGameTasks:
	ldx xpos		;Get Current XY pos.
	ldy ypos

	lda $0280		;%RLDUrldu Player $01 
	bit Bit4		;1=Not pressed 0=Pressed
	bne JoyNotUp
	dec Ypos
JoyNotUp:	
	bit Bit5
	bne JoyNotDown
	inc Ypos
JoyNotDown:	
	bit Bit6
	bne JoyNotLeft
	dec Xpos
JoyNotLeft:	
	bit Bit7
	bne JoyNotRight
	inc Xpos
JoyNotRight:	

	
	lda xpos
	cmp #172-8		;Far right of screen
	bcc XposNotOver
	stx xpos		;Reset X
XposNotOver:		

	lda ypos		
	cmp #191-16		;Bottom of screen
	bcc yposNotOver
	sty ypos		;Reset Y
YposNotOver:		
		
	
	ldx #$88		;Mid blue   	  %CCCCLLLL - Color / Luminence
	lda $3C			;$003C=Fire? %F-------
	bmi JoyNoFire	
	ldx #$8F		;Yes=Light blue   %CCCCLLLL - Color / Luminence
JoyNoFire	
	stx $06			;COLUP0: player color 
	
	
	lda xpos		;%----MMMM Move -8 (R) to +7 (L)
	sta $02 		;wsync	
	and #%00001111	
	tax
	lda ShiftLut,x	;Convert via LUT
	sta $20			;HMP0: Player move (Horiz Motion P0)

	
	lda Xpos		;%RRRR---- Raster pos
	sec
WaitXpos:
	sbc #16			;Count to A/16
	bcs WaitXpos
	sta $10			;RESP0: Set Xpos to raster pos (Reset P0)
		
		
	sta $02 		;WSYNC
					;(tweak xpos - do after wsync)
	sta $2A			;HMOVE: horizontal motion player 0
	rts
	
	
	
WaitTimer:			;Wait for timer to end, and do a wsync
	lda $285
	bpl WaitTimer
	sta $02 		;wsync
	rts


;Our sprite... must be 1 byte wide!
MySprite:
	db %11111111
	db %01111110
	db %00000000
	db %10000001
	db %10000001
	db %10000001
	db %10011001
	db %10100101
	db %10100101
	db %10011001
	db %10000001
	db %10000001
	db %10000001
	db %00000000
	db %01111110
	db %11111111

;Shift lut for sprite offsets ($20)
ShiftLut:
	db %01110000 ;Left +7
	db %01100000 ;Left +6
	db %01010000 ;Left +5
	db %01000000 ;Left +4
	db %00110000 ;Left +3
	db %00100000 ;Left +2
	db %00010000 ;Left +1
	db %00000000 ;0
	db %11110000 ;Right -1
	db %11100000 ;Right -2
	db %11010000 ;Right -3
	db %11000000 ;Right -4
	db %10110000 ;Right -5
	db %10100000 ;Right -6
	db %10010000 ;Right -7
	db %10000000 ;Right -8
	
	
;Bit LUT for testing Joy buttons
Bit0:	db %00000001
Bit1:	db %00000010
Bit2:	db %00000100
Bit3:	db %00001000
Bit4:	db %00010000
Bit5:	db %00100000
Bit6:	db %01000000
Bit7:	db %10000000
	

    ORG $FFFC 
    dw ProgStart	;Reset
    dw ProgStart	;Break

	
; Type_______NTSC__PAL/SECAM______
; V-Sync      3     3    scanlines
; V-Blank     37    45   scanlines (upper border)
; Picture     192   228  scanlines
; Overscan    30    36   scanlines (lower border)
; Frame Rate  60    50   Hz
; Frame Time  262   312  scanlines	


; Blanking  22.6 machine clocks (68 color clocks)
; Picture   53.3 machine clocks (160 color clocks) (160 pixels)
; Total     76.0 machine clocks (228 color clocks)
	