VSYNC equ $00
VBLANK equ $01
WSYNC equ $02
CTRLPF equ $0a
COLUPF equ $08
COLUBK equ $09
PF0 equ $0d
PF1 equ $0e
PF2 equ $0f
GRP0 equ $1b
GRP1 equ $1c
ENAM0 equ $1d
ENAM1 equ $1e
ENABL  equ $1f


SoundVol  equ $80
SoundCtl  equ $81
SoundFrq  equ $82

TimeTick equ $83

    ORG $F000       ; Start of "cart area" (see Atari memory map)
ProgStart:
	lda #1
	sta SoundVol
	sta SoundCtl
	sta SoundFrq
	

	sta CTRLPF		;1=Mirror PF

	lda #$FF
	sta COLUPF
	
DoFrame:
    lda #%00000010  ;Start vsync
    sta $00			;vsync
    	
    sta $02 		;wsync - 3 lines
	sta $02 		;wsync
	sta $02 		;wsync
	
    lda #0			;End Vsync
    sta $00 		;vsync

	lda #43			;76 ticks per line *37 lines /64 ticks per timer
	sta $296
	
	jsr DoGameTasks
	
	jsr WaitTimer	;Wait for the timer to end
	
	lda #0          ;End vblank
	sta $01 		;vblank
	
	ldx #0			;Scanline
DoScanLine:
		
	lda SoundVol	;%----VVVV
	rol
	rol
	rol
	rol
	sta PF0      	;Left 4 pixels
	
	lda SoundCtl	;%----TTTT
	and #%00001111
	rol
	rol
	sta PF1     	;Center 8 pixels
	
	lda SoundFrq	;%---FFFFF
	and #%00011111
	sta PF2 		;Right 8 pixels
	
	sta $02 		;wsync

    inx       
    cpx #191
    bne DoScanLine
	
	
;Overscan
	lda #35			;76 ticks per line *30 lines /64 ticks per timer
	sta $296
	
	lda #%01000010  ;Start Vblank
    sta $01 		;vblank
	
	jsr WaitTimer	
	
    jmp DoFrame 	;Next frame

	
WaitTimer:			;Wait for timer to end, and do a wsync
	lda $285
	bpl WaitTimer
	sta $02 		;wsync
	rts
	
	
DoGameTasks:
	inc TimeTick
	lda TimeTick
	and #%00001111	;update 1/16 ticks
	bne DoGameTasksDone

	
 	lda $0280		;%RLDUrldu Player $01 
	bit Bit4		;1=Not pressed 0=Pressed
	bne JoyNotUp	
	dec SoundCtl	;Change Tone type
JoyNotUp:	
	bit Bit5
	bne JoyNotDown
	inc SoundCtl	;Change Tone type
JoyNotDown:	
	bit Bit6
	bne JoyNotLeft
	dec SoundFrq	;Change Pitch (Higher)
JoyNotLeft:	
	bit Bit7
	bne JoyNotRight
	inc SoundFrq	;Change Pitch (Lower)
JoyNotRight:	

	
	ldx #4			;Quiet
	lda $3C			;$003C=Fire? %F-------
	bmi JoyNoFire
	ldx #15			;Loud!
JoyNoFire	
	stx SoundVol
	 
	
	lda SoundCtl
	sta $0015		;Tone   0	%----TTTT (8=noise 4=pure tone)
	;sta $0016		;Tone   1	%----TTTT (8=noise 4=pure tone)
	
	lda SoundFrq
	sta $0017		;Freq 0		%---FFFFF (0=Highest 31=lowest)
	;sta $0018		;Freq 1		%---FFFFF (0=Highest 31=lowest)
	
	lda SoundVol
	sta $0019		;Volume 0	%----VVVV (15=Loudest)
	;sta $001A		;Volume 1	%----VVVV (15=Loudest)
	
	
DoGameTasksDone:
	rts
	

;Bit LUT for testing Joy buttons
Bit0:	db %00000001
Bit1:	db %00000010
Bit2:	db %00000100
Bit3:	db %00001000
Bit4:	db %00010000
Bit5:	db %00100000
Bit6:	db %01000000
Bit7:	db %10000000	
	
	
    ORG $FFFC 
    dw ProgStart	;Reset
    dw ProgStart	;Break


	
;Bit 0-3, Noise/Division Control
;  0  set to 1                    8  9 bit poly (white noise)
;  1  4 bit poly                  9  5 bit poly
;  2  div 15 -> 4 bit poly        A  div 31 : pure tone
;  3  5 bit poly -> 4 bit poly    B  set last 4 bits to 1
;  4  div 2 : pure tone           C  div 6 : pure tone
;  5  div 2 : pure tone           D  div 6 : pure tone
;  6  div 31 : pure tone          E  div 93 : pure tone
;  7  5 bit poly -> div 2         F  5 bit poly div 6
	