{-# LANGUAGE TemplateHaskell, FlexibleInstances,
             OverlappingInstances, UndecidableInstances #-}

module Xml.PrintParse where

import Text.PrettyPrint.HughesPJ
import Text.XML.HaXml.Parse
import Text.XML.HaXml.Pretty
import Text.XML.HaXml.Types (Document(Document), Content(CElem))
import Xml.Base
import Xml.HaXml
import Data.Maybe

toString :: Element -> String
toString = render . content . toHaXml

toStrings :: [Element] -> String
toStrings = render . vcat . map (content . toHaXml)

--fromString :: String -> Element

class FromString a where
    fromString::String->Maybe a

instance FromString Element where
    fromString s = case xmlParse "NoFile" s of
                     Document _ _ e _ ->
                         return $ fromHaXml $ CElem e
                     _ -> Nothing

instance (Xml a) => FromString a where
    fromString x =  do
                    el <- fromString x
                    fromXml [el]

